/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.util.SystemUtils;
import org.apereo.cas.util.feature.CasRuntimeModuleLoader;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

public class CasInfoEndpointContributor
implements InfoContributor {
    private final CasConfigurationProperties casProperties;
    private final CasRuntimeModuleLoader loader;

    public void contribute(Info.Builder builder) {
        builder.withDetail("systemInfo", (Object)SystemUtils.getSystemInfo());
        builder.withDetail("casModules", Unchecked.supplier(() -> ((CasRuntimeModuleLoader)this.loader).load()).get());
        builder.withDetail("server", Map.of("hostname", (String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getHost().getName(), (CharSequence)"N/A"), "host", InetAddressUtils.getCasServerHostName(), "name", (String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getServer().getName(), (CharSequence)"N/A"), "scope", (String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getServer().getScope(), (CharSequence)"N/A")));
    }

    @Generated
    public CasInfoEndpointContributor(CasConfigurationProperties casProperties, CasRuntimeModuleLoader loader) {
        this.casProperties = casProperties;
        this.loader = loader;
    }
}

