/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.ws.rs.core.Response;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.syncope.common.lib.to.ErrorTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.DomainHolder;

public class SyncopeOpenApiCustomizer
extends OpenApiCustomizer {
    private final DomainHolder<?> domainHolder;

    public SyncopeOpenApiCustomizer(DomainHolder<?> domainHolder) {
        this.domainHolder = domainHolder;
    }

    public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
        super.customize(configuration);
        MessageContext ctx = (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
        String url = StringUtils.substringBeforeLast((String)ctx.getUriInfo().getRequestUri().getRawPath(), (String)"/");
        configuration.getOpenAPI().setServers(List.of(new Server().url(url)));
        return configuration;
    }

    public void customize(OpenAPI oas) {
        if (oas.getPaths() == null) {
            oas.setPaths(new Paths());
        }
        super.customize(oas);
    }

    protected void addParameters(List<Parameter> parameters) {
        Optional<Parameter> delegatedByHeaderParameter;
        Optional<Parameter> domainHeaderParameter = parameters.stream().filter(p -> p instanceof HeaderParameter && "X-Syncope-Domain".equals(p.getName())).findFirst();
        if (domainHeaderParameter.isEmpty()) {
            HeaderParameter parameter = new HeaderParameter();
            parameter.setName("X-Syncope-Domain");
            parameter.setRequired(Boolean.valueOf(true));
            ExternalDocumentation extDoc = new ExternalDocumentation();
            extDoc.setDescription("Apache Syncope Reference Guide");
            extDoc.setUrl("https://syncope.apache.org/docs/3.0/reference-guide.html#domains");
            Schema schema = new Schema();
            schema.setDescription("Domains are built to facilitate multitenancy.");
            schema.setExternalDocs(extDoc);
            schema.setEnum(this.domainHolder.getDomains().keySet().stream().sorted().toList());
            schema.setDefault((Object)"Master");
            parameter.setSchema(schema);
            parameters.add((Parameter)parameter);
        }
        if ((delegatedByHeaderParameter = parameters.stream().filter(p -> p instanceof HeaderParameter && "X-Syncope-Delegated-By".equals(p.getName())).findFirst()).isEmpty()) {
            HeaderParameter parameter = new HeaderParameter();
            parameter.setName("X-Syncope-Delegated-By");
            parameter.setRequired(Boolean.valueOf(false));
            ExternalDocumentation extDoc = new ExternalDocumentation();
            extDoc.setDescription("Apache Syncope Reference Guide");
            extDoc.setUrl("https://syncope.apache.org/docs/3.0/reference-guide.html#delegation");
            Schema schema = new Schema();
            schema.setDescription("Acton behalf of someone else");
            schema.setExternalDocs(extDoc);
            parameter.setSchema(schema);
            parameters.add((Parameter)parameter);
        }
    }

    protected void customizeResponses(Operation operation, OperationResourceInfo ori) {
        super.customizeResponses(operation, ori);
        ApiResponses responses = Optional.ofNullable(operation.getResponses()).orElseGet(() -> {
            ApiResponses r = new ApiResponses();
            operation.setResponses(r);
            return r;
        });
        Optional.ofNullable((ApiResponse)responses.get((Object)"default")).ifPresent(defaultResponse -> {
            responses.remove((Object)"default");
            responses.addApiResponse("200", defaultResponse);
        });
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        headers.put("X-Application-Error-Code", new Header().schema(new Schema().type("string")).description("Error code"));
        headers.put("X-Application-Error-Info", new Header().schema(new Schema().type("string")).description("Error message(s)"));
        ErrorTO sampleError = new ErrorTO();
        sampleError.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        sampleError.setType(ClientExceptionType.InvalidEntity);
        sampleError.getElements().add("error message");
        Schema errorSchema = new Schema();
        errorSchema.example((Object)sampleError).addProperty("status", new IntegerSchema().description("HTTP status code")).addProperty("type", new StringSchema()._enum(Stream.of(ClientExceptionType.values()).map(Enum::name).toList()).description("Error code")).addProperty("elements", new ArraySchema().type("string").description("Error message(s)"));
        Content content = new Content();
        content.addMediaType("application/json", new MediaType().schema(errorSchema));
        content.addMediaType("application/yaml", new MediaType().schema(errorSchema));
        content.addMediaType("application/xml", new MediaType().schema(errorSchema));
        responses.addApiResponse("400", new ApiResponse().description("An error occurred; HTTP status code can vary depending on the actual error: 400, 403, 404, 409, 412").headers(headers).content(content));
    }
}

