/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.toolbar;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.sort.AjaxOrderByLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByLink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.toolbar.AbstractEditableToolbar;

public class HeadersToolbar<S>
extends AbstractEditableToolbar {
    private static final long serialVersionUID = 1L;

    public <T> HeadersToolbar(final EditableDataTable<T, S> table, final ISortStateLocator<S> stateLocator) {
        super(table);
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(Model.of(column));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                final IColumn column = (IColumn)item.getModelObject();
                WebMarkupContainer header = column.isSortable() && !table.isCurrentlyAnyEdit() ? HeadersToolbar.this.newSortableHeader("header", column.getSortProperty(), stateLocator) : new WebMarkupContainer("header");
                if (column instanceof IStyledColumn) {
                    EditableDataTable.CssAttributeBehavior cssAttributeBehavior = new EditableDataTable.CssAttributeBehavior(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected String getCssClass() {
                            return ((IStyledColumn)column).getCssClass();
                        }
                    };
                    header.add(new Behavior[]{cssAttributeBehavior});
                }
                if (column.getHeaderColspan() > 1) {
                    header.add(new Behavior[]{new AttributeModifier("colspan", (Serializable)Integer.valueOf(column.getHeaderColspan()))});
                    header.add(new Behavior[]{new AttributeModifier("scope", (Serializable)((Object)"colgroup"))});
                } else {
                    header.add(new Behavior[]{new AttributeModifier("scope", (Serializable)((Object)"col"))});
                }
                if (column.getHeaderRowspan() > 1) {
                    header.add(new Behavior[]{new AttributeModifier("rowspan", (Serializable)Integer.valueOf(column.getHeaderRowspan()))});
                }
                header.add(new Component[]{column.getHeader("label")});
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
            }
        };
        this.add(new Component[]{headers});
    }

    protected WebMarkupContainer newSortableHeader(String headerId, S property, ISortStateLocator<S> locator) {
        return new OrderByBorder<S>(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected OrderByLink<S> newOrderByLink(String id, S property, ISortStateLocator<S> stateLocator) {
                return new AjaxOrderByLink<S>(id, property, stateLocator){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        target.add(new Component[]{HeadersToolbar.this.getTable()});
                    }

                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        HeadersToolbar.this.updateAjaxAttributes(attributes);
                    }
                };
            }

            protected void onSortChanged() {
                HeadersToolbar.this.getTable().setCurrentPage(0L);
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }
}

