/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AcceptableUsagePolicyVerifyServiceAction
extends BaseCasWebflowAction {
    private final AcceptableUsagePolicyRepository repository;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Audit(action="AUP_VERIFY", actionResolverName="AUP_VERIFY_ACTION_RESOLVER", resourceResolverName="AUP_VERIFY_RESOURCE_RESOLVER")
    protected Event doExecuteInternal(RequestContext requestContext) {
        return (Event)FunctionUtils.doUnchecked(() -> this.verify(requestContext));
    }

    private Event verify(RequestContext context) throws Throwable {
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)WebUtils.getRegisteredService((RequestContext)context);
        if (registeredService != null) {
            Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            EventFactorySupport eventFactorySupport = new EventFactorySupport();
            AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(authentication).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            boolean aupEnabled = registeredService.getAcceptableUsagePolicy() != null && registeredService.getAcceptableUsagePolicy().isEnabled();
            AcceptableUsagePolicyStatus res = (AcceptableUsagePolicyStatus)ObjectUtils.defaultIfNull((Object)(aupEnabled ? this.repository.verify(context) : null), (Object)AcceptableUsagePolicyStatus.skipped((Principal)authentication.getPrincipal()));
            if (res.isDenied()) {
                return eventFactorySupport.event((Object)this, "mustAcceptUsagePolicy");
            }
        }
        return null;
    }

    @Generated
    public AcceptableUsagePolicyVerifyServiceAction(AcceptableUsagePolicyRepository repository, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.repository = repository;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

