/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceSecurityPanel
extends WizardStep {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    protected final IModel<Map<String, String>> passwordPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected Map<String, String> load() {
            return ResourceSecurityPanel.this.policyRestClient.list(PolicyType.PASSWORD).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> accountPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ResourceSecurityPanel.this.policyRestClient.list(PolicyType.ACCOUNT).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> propagationPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ResourceSecurityPanel.this.policyRestClient.list(PolicyType.PROPAGATION).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> pullPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ResourceSecurityPanel.this.policyRestClient.list(PolicyType.INBOUND).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> pushPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = 9089911876466472133L;

        protected Map<String, String> load() {
            return ResourceSecurityPanel.this.policyRestClient.list(PolicyType.PUSH).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };

    public ResourceSecurityPanel(ResourceTO resourceTO) {
        this.setOutputMarkupId(true);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        container.setRenderBodyOnly(true);
        this.add(new Component[]{container});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", new ResourceModel("passwordPolicy", "passwordPolicy").getObject(), (IModel)new PropertyModel((Object)resourceTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)this.passwordPolicies.getObject()));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        container.add(new Component[]{passwordPolicy});
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", new ResourceModel("accountPolicy", "accountPolicy").getObject(), (IModel)new PropertyModel((Object)resourceTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)this.accountPolicies.getObject()));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        container.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel propagationPolicy = new AjaxDropDownChoicePanel("propagationPolicy", new ResourceModel("propagationPolicy", "propagationPolicy").getObject(), (IModel)new PropertyModel((Object)resourceTO, "propagationPolicy"), false);
        propagationPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)this.propagationPolicies.getObject()));
        propagationPolicy.setChoices(new ArrayList(((Map)this.propagationPolicies.getObject()).keySet()));
        ((DropDownChoice)propagationPolicy.getField()).setNullValid(true);
        container.add(new Component[]{propagationPolicy});
        AjaxDropDownChoicePanel inboundPolicy = new AjaxDropDownChoicePanel("inboundPolicy", new ResourceModel("inboundPolicy", "inboundPolicy").getObject(), (IModel)new PropertyModel((Object)resourceTO, "inboundPolicy"), false);
        inboundPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)this.pullPolicies.getObject()));
        inboundPolicy.setChoices(new ArrayList(((Map)this.pullPolicies.getObject()).keySet()));
        ((DropDownChoice)inboundPolicy.getField()).setNullValid(true);
        container.add(new Component[]{inboundPolicy});
        AjaxDropDownChoicePanel pushPolicy = new AjaxDropDownChoicePanel("pushPolicy", new ResourceModel("pushPolicy", "pushPolicy").getObject(), (IModel)new PropertyModel((Object)resourceTO, "pushPolicy"), false);
        pushPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)this.pushPolicies.getObject()));
        pushPolicy.setChoices(new ArrayList(((Map)this.pushPolicies.getObject()).keySet()));
        ((DropDownChoice)pushPolicy.getField()).setNullValid(true);
        container.add(new Component[]{pushPolicy});
    }
}

