/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.Set;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableListenerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableListenerUtil.class);

    public static boolean hasVariableListenerEventDefinitions(String processDefinitionId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        return bpmnModel.hasVariableListeners();
    }

    public static boolean hasVariableListenerEventDefinitionsForVariableName(String processDefinitionId, String variableName) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        return bpmnModel.containsVariableListenerForVariableName(variableName);
    }

    public static boolean hasVariableListenerEventDefinitionsForVariableNames(String processDefinitionId, Set<String> variableNames) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        for (String variableName : variableNames) {
            if (!bpmnModel.containsVariableListenerForVariableName(variableName)) continue;
            return true;
        }
        return false;
    }
}

