/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.springframework.util.StringUtils;

public class DefaultAttributeRepositoryResolver
implements AttributeRepositoryResolver {
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;

    public Set<String> resolve(AttributeRepositoryResolver.AttributeRepositoryQuery query) {
        HashSet<String> repositoryIds = new HashSet<String>();
        this.determineRegisteredService(query).map(RegisteredService::getAttributeReleasePolicy).map(RegisteredServiceAttributeReleasePolicy::getPrincipalAttributesRepository).map(RegisteredServicePrincipalAttributesRepository::getAttributeRepositoryIds).filter(identifiers -> !identifiers.isEmpty()).ifPresentOrElse(repositoryIds::addAll, () -> {
            Map selectionMap = this.casProperties.getPersonDirectory().getAttributeRepositorySelection();
            if (Objects.nonNull(query.getAuthenticationHandler()) && selectionMap.containsKey(query.getAuthenticationHandler().getName())) {
                Set assignedRepositories = StringUtils.commaDelimitedListToSet((String)((String)selectionMap.get(query.getAuthenticationHandler().getName())));
                repositoryIds.addAll(assignedRepositories);
            } else if (Objects.nonNull(query.getActiveRepositoryIds())) {
                repositoryIds.addAll(query.getActiveRepositoryIds());
            }
        });
        if (repositoryIds.isEmpty()) {
            repositoryIds.add("*");
        }
        return repositoryIds;
    }

    protected Optional<RegisteredService> determineRegisteredService(AttributeRepositoryResolver.AttributeRepositoryQuery query) {
        RegisteredService result = Optional.ofNullable(query.getService()).map(arg_0 -> ((ServicesManager)this.servicesManager).findServiceBy(arg_0)).orElseGet(() -> ((AttributeRepositoryResolver.AttributeRepositoryQuery)query).getRegisteredService());
        return Optional.ofNullable(result);
    }

    @Generated
    public DefaultAttributeRepositoryResolver(ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

