/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OAuth20UsernamePasswordAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UsernamePasswordAuthenticator.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServicesManager servicesManager;
    private final ServiceFactory webApplicationServiceFactory;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ClientSecretValidator clientSecretValidator;
    private final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    private final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
    private final TicketFactory ticketFactory;
    private final ConfigurableApplicationContext applicationContext;

    public Optional<Credentials> validate(CallContext callContext, Credentials credentials) throws CredentialsException {
        try {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            UsernamePasswordCredential casCredential = new UsernamePasswordCredential(upc.getUsername(), upc.getPassword());
            Pair clientIdAndSecret = this.requestParameterResolver.resolveClientIdAndClientSecret(callContext);
            if (StringUtils.isBlank((CharSequence)((CharSequence)clientIdAndSecret.getKey()))) {
                throw new CredentialsException("No client credentials could be identified in this request");
            }
            String clientId = (String)clientIdAndSecret.getKey();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            String clientSecret = (String)clientIdAndSecret.getRight();
            if (!this.clientSecretValidator.validate(registeredService, clientSecret)) {
                throw new CredentialsException("Client Credentials provided is not valid for registered service: " + Objects.requireNonNull(registeredService).getName());
            }
            String redirectUri = this.requestParameterResolver.resolveRequestParameter(callContext.webContext(), "redirect_uri").map(String::valueOf).orElse("");
            OAuth20Utils.validateRedirectUri(redirectUri);
            Service service = StringUtils.isNotBlank((CharSequence)redirectUri) ? this.webApplicationServiceFactory.createService(redirectUri) : this.webApplicationServiceFactory.createService(clientId);
            service.getAttributes().put("client_id", CollectionUtils.wrapList((Object[])new String[]{clientId}));
            service.getAttributes().put("redirect_uri", CollectionUtils.wrapList((Object[])new String[]{redirectUri}));
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.finalizeAuthenticationTransaction(service, new Credential[]{casCredential});
            if (authenticationResult == null) {
                throw new CredentialsException("Could not authenticate the provided credentials");
            }
            Principal principal = this.buildAuthenticatedPrincipal(authenticationResult, registeredService, service, callContext);
            CommonProfile profile = new CommonProfile();
            profile.setId(principal.getId());
            profile.addAttribute("client_id", (Object)clientId);
            profile.addAttributes(principal.getAttributes());
            Authentication authentication = authenticationResult.getAuthentication();
            Map authnAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(authentication, (RegisteredService)registeredService);
            profile.addAuthenticationAttributes(new HashMap(authnAttributes));
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile((UserProfile)profile);
            return Optional.of(credentials);
        }
        catch (Throwable e) {
            throw new CredentialsException("Cannot login user using CAS internal authentication", e);
        }
    }

    protected Principal buildAuthenticatedPrincipal(AuthenticationResult authenticationResult, OAuthRegisteredService registeredService, Service service, CallContext callContext) throws Throwable {
        Authentication authentication = authenticationResult.getAuthentication();
        Principal principal = authentication.getPrincipal();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service(service).principal(principal).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = registeredService.getUsernameAttributeProvider().resolveUsername(usernameContext);
        LOGGER.debug("Created profile id [{}]", (Object)id);
        OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)this.ticketFactory.get(OAuth20AccessToken.class);
        Collection scopes = this.requestParameterResolver.resolveRequestedScopes(callContext.webContext());
        OAuth20ResponseTypes responseType = this.requestParameterResolver.resolveResponseType(callContext.webContext());
        OAuth20GrantTypes grantType = this.requestParameterResolver.resolveGrantType(callContext.webContext());
        OAuth20AccessToken accessToken = accessTokenFactory.create(service, authentication, scopes, registeredService.getClientId(), responseType, grantType);
        Principal finalPrincipal = this.profileScopeToAttributesFilter.filter(service, principal, (RegisteredService)registeredService, accessToken);
        LOGGER.debug("Built final principal [{}]", (Object)finalPrincipal);
        return finalPrincipal;
    }

    @Generated
    public OAuth20UsernamePasswordAuthenticator(AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, TicketFactory ticketFactory, ConfigurableApplicationContext applicationContext) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.requestParameterResolver = requestParameterResolver;
        this.clientSecretValidator = clientSecretValidator;
        this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
        this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
        this.ticketFactory = ticketFactory;
        this.applicationContext = applicationContext;
    }
}

