/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ThemeResolver;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;

public class ThemeFileTemplateResolver
extends FileTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeFileTemplateResolver.class);
    protected final CasConfigurationProperties casProperties;
    protected final ThemeResolver themeResolver;

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        String themeName = this.themeResolver.resolveThemeName(request);
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            String themeTemplate = String.format(resourceName, themeName);
            LOGGER.trace("Computing template resource [{}]...", (Object)themeTemplate);
            return super.computeTemplateResource(configuration, ownerTemplate, template, themeTemplate, characterEncoding, templateResolutionAttributes);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }

    @Generated
    public ThemeFileTemplateResolver(CasConfigurationProperties casProperties, ThemeResolver themeResolver) {
        this.casProperties = casProperties;
        this.themeResolver = themeResolver;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public ThemeResolver getThemeResolver() {
        return this.themeResolver;
    }
}

