/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.net.URI;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowAuthenticationExceptionHandler
implements CasWebflowExceptionHandler<AuthenticationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowAuthenticationExceptionHandler.class);
    private final CasWebflowExceptionCatalog errors;
    private int order = 0x7FFFFFFE;

    @Override
    public Event handle(AuthenticationException exception, RequestContext requestContext) {
        String id = this.handleAuthenticationException(exception, requestContext);
        WebUtils.trackFailedAuthenticationAttempt((RequestContext)requestContext);
        return new EventFactorySupport().event((Object)this, id);
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception instanceof AuthenticationException;
    }

    protected String handleAuthenticationException(AuthenticationException exception, RequestContext requestContext) {
        URI url;
        if (exception.getHandlerErrors().containsKey(UnauthorizedServiceForPrincipalException.class.getSimpleName()) && (url = WebUtils.getUnauthorizedRedirectUrlFromFlowScope((RequestContext)requestContext)) != null) {
            LOGGER.warn("Unauthorized service access for principal; CAS will be redirecting to [{}]", (Object)url);
            return "serviceUnauthorizedCheck";
        }
        return this.errors.translateException(requestContext, (Exception)exception);
    }

    @Generated
    public CasWebflowExceptionCatalog getErrors() {
        return this.errors;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public DefaultCasWebflowAuthenticationExceptionHandler(CasWebflowExceptionCatalog errors) {
        this.errors = errors;
    }
}

