/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import java.net.URI;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SwtInterceptingBrowser {
    private Display display;
    private Browser browser;
    private final Lock lock = new ReentrantLock();
    private final Condition responseReceived = this.lock.newCondition();
    private String redirectUriString;
    private String destinationUriString;
    private String response;

    public SwtInterceptingBrowser(Browser browser, Display display, Shell shell) {
        this.browser = browser;
        this.display = display;
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                super.changing(locationEvent);
                String newValue = locationEvent.location;
                SwtInterceptingBrowser.this.lock.lock();
                try {
                    if (SwtInterceptingBrowser.this.redirectUriString != null && newValue != null && newValue.startsWith(SwtInterceptingBrowser.this.redirectUriString)) {
                        locationEvent.doit = false;
                        SwtInterceptingBrowser.this.response = UserAgentImpl.extractResponseFromRedirectUri(newValue);
                        SwtInterceptingBrowser.this.responseReceived.signal();
                    }
                }
                finally {
                    SwtInterceptingBrowser.this.lock.unlock();
                }
            }
        });
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                SwtInterceptingBrowser.this.lock.lock();
                try {
                    SwtInterceptingBrowser.this.response = "error=cancelled&error_description=The browser window was closed by the user.";
                    SwtInterceptingBrowser.this.responseReceived.signal();
                }
                finally {
                    SwtInterceptingBrowser.this.lock.unlock();
                }
            }
        });
    }

    public void sendRequest(URI destinationUri, URI redirectUri) {
        this.destinationUriString = destinationUri.toString();
        this.redirectUriString = redirectUri.toString();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SwtInterceptingBrowser.this.browser.setUrl(SwtInterceptingBrowser.this.destinationUriString);
            }
        });
    }

    public AuthorizationResponse waitForResponse() throws AuthorizationException {
        this.lock.lock();
        try {
            this.responseReceived.awaitUninterruptibly();
            AuthorizationResponse authorizationResponse = AuthorizationResponse.fromString(this.response);
            return authorizationResponse;
        }
        finally {
            this.lock.unlock();
        }
    }
}

