/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AuthenticatorAssertionExtensionOutputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AssertionResult {
    private final boolean success;
    @NonNull
    private final ByteArray credentialId;
    @NonNull
    private final ByteArray userHandle;
    @NonNull
    private final String username;
    private final long signatureCount;
    private final boolean signatureCounterValid;
    private final ClientAssertionExtensionOutputs clientExtensionOutputs;
    private final AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs;

    @JsonCreator
    private AssertionResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="credentialId") @NonNull ByteArray credentialId, @JsonProperty(value="userHandle") @NonNull ByteArray userHandle, @JsonProperty(value="username") @NonNull String username, @JsonProperty(value="signatureCount") long signatureCount, @JsonProperty(value="signatureCounterValid") boolean signatureCounterValid, @JsonProperty(value="clientExtensionOutputs") ClientAssertionExtensionOutputs clientExtensionOutputs, @JsonProperty(value="authenticatorExtensionOutputs") AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.success = success;
        this.credentialId = credentialId;
        this.userHandle = userHandle;
        this.username = username;
        this.signatureCount = signatureCount;
        this.signatureCounterValid = signatureCounterValid;
        this.clientExtensionOutputs = clientExtensionOutputs == null || clientExtensionOutputs.getExtensionIds().isEmpty() ? null : clientExtensionOutputs;
        this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
    }

    public Optional<ClientAssertionExtensionOutputs> getClientExtensionOutputs() {
        return Optional.ofNullable(this.clientExtensionOutputs);
    }

    public Optional<AuthenticatorAssertionExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return Optional.ofNullable(this.authenticatorExtensionOutputs);
    }

    static AssertionResultBuilder.MandatoryStages builder() {
        return new AssertionResultBuilder.MandatoryStages();
    }

    @Generated
    public AssertionResultBuilder toBuilder() {
        return new AssertionResultBuilder().success(this.success).credentialId(this.credentialId).userHandle(this.userHandle).username(this.username).signatureCount(this.signatureCount).signatureCounterValid(this.signatureCounterValid).clientExtensionOutputs(this.clientExtensionOutputs).authenticatorExtensionOutputs(this.authenticatorExtensionOutputs);
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @NonNull
    @Generated
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @NonNull
    @Generated
    public ByteArray getUserHandle() {
        return this.userHandle;
    }

    @NonNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @Generated
    public boolean isSignatureCounterValid() {
        return this.signatureCounterValid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionResult)) {
            return false;
        }
        AssertionResult other = (AssertionResult)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
            return false;
        }
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        ByteArray this$userHandle = this.getUserHandle();
        ByteArray other$userHandle = other.getUserHandle();
        if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Optional<ClientAssertionExtensionOutputs> this$clientExtensionOutputs = this.getClientExtensionOutputs();
        Optional<ClientAssertionExtensionOutputs> other$clientExtensionOutputs = other.getClientExtensionOutputs();
        if (this$clientExtensionOutputs == null ? other$clientExtensionOutputs != null : !((Object)this$clientExtensionOutputs).equals(other$clientExtensionOutputs)) {
            return false;
        }
        Optional<AuthenticatorAssertionExtensionOutputs> this$authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        Optional<AuthenticatorAssertionExtensionOutputs> other$authenticatorExtensionOutputs = other.getAuthenticatorExtensionOutputs();
        return !(this$authenticatorExtensionOutputs == null ? other$authenticatorExtensionOutputs != null : !((Object)this$authenticatorExtensionOutputs).equals(other$authenticatorExtensionOutputs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        ByteArray $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Optional<ClientAssertionExtensionOutputs> $clientExtensionOutputs = this.getClientExtensionOutputs();
        result = result * 59 + ($clientExtensionOutputs == null ? 43 : ((Object)$clientExtensionOutputs).hashCode());
        Optional<AuthenticatorAssertionExtensionOutputs> $authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        result = result * 59 + ($authenticatorExtensionOutputs == null ? 43 : ((Object)$authenticatorExtensionOutputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionResult(success=" + this.isSuccess() + ", credentialId=" + this.getCredentialId() + ", userHandle=" + this.getUserHandle() + ", username=" + this.getUsername() + ", signatureCount=" + this.getSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ", clientExtensionOutputs=" + this.getClientExtensionOutputs() + ", authenticatorExtensionOutputs=" + this.getAuthenticatorExtensionOutputs() + ")";
    }

    static class AssertionResultBuilder {
        @Generated
        private boolean success;
        @Generated
        private ByteArray credentialId;
        @Generated
        private ByteArray userHandle;
        @Generated
        private String username;
        @Generated
        private long signatureCount;
        @Generated
        private boolean signatureCounterValid;
        @Generated
        private ClientAssertionExtensionOutputs clientExtensionOutputs;
        @Generated
        private AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs;

        @Generated
        AssertionResultBuilder() {
        }

        @Generated
        public AssertionResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Generated
        public AssertionResultBuilder credentialId(@NonNull ByteArray credentialId) {
            if (credentialId == null) {
                throw new NullPointerException("credentialId is marked non-null but is null");
            }
            this.credentialId = credentialId;
            return this;
        }

        @Generated
        public AssertionResultBuilder userHandle(@NonNull ByteArray userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            this.userHandle = userHandle;
            return this;
        }

        @Generated
        public AssertionResultBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        @Generated
        public AssertionResultBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        @Generated
        public AssertionResultBuilder signatureCounterValid(boolean signatureCounterValid) {
            this.signatureCounterValid = signatureCounterValid;
            return this;
        }

        @Generated
        public AssertionResultBuilder clientExtensionOutputs(ClientAssertionExtensionOutputs clientExtensionOutputs) {
            this.clientExtensionOutputs = clientExtensionOutputs;
            return this;
        }

        @Generated
        public AssertionResultBuilder authenticatorExtensionOutputs(AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
            this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
            return this;
        }

        @Generated
        public AssertionResult build() {
            return new AssertionResult(this.success, this.credentialId, this.userHandle, this.username, this.signatureCount, this.signatureCounterValid, this.clientExtensionOutputs, this.authenticatorExtensionOutputs);
        }

        @Generated
        public String toString() {
            return "AssertionResult.AssertionResultBuilder(success=" + this.success + ", credentialId=" + this.credentialId + ", userHandle=" + this.userHandle + ", username=" + this.username + ", signatureCount=" + this.signatureCount + ", signatureCounterValid=" + this.signatureCounterValid + ", clientExtensionOutputs=" + this.clientExtensionOutputs + ", authenticatorExtensionOutputs=" + this.authenticatorExtensionOutputs + ")";
        }

        public static class MandatoryStages {
            private final AssertionResultBuilder builder = new AssertionResultBuilder();

            public Step2 success(boolean success) {
                this.builder.success(success);
                return new Step2();
            }

            public class Step8 {
                public AssertionResultBuilder assertionExtensionOutputs(AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
                    return MandatoryStages.this.builder.authenticatorExtensionOutputs(authenticatorExtensionOutputs);
                }
            }

            public class Step7 {
                public Step8 clientExtensionOutputs(ClientAssertionExtensionOutputs clientExtensionOutputs) {
                    MandatoryStages.this.builder.clientExtensionOutputs(clientExtensionOutputs);
                    return new Step8();
                }
            }

            public class Step6 {
                public Step7 signatureCounterValid(boolean signatureCounterValid) {
                    MandatoryStages.this.builder.signatureCounterValid(signatureCounterValid);
                    return new Step7();
                }
            }

            public class Step5 {
                public Step6 signatureCount(long signatureCount) {
                    MandatoryStages.this.builder.signatureCount(signatureCount);
                    return new Step6();
                }
            }

            public class Step4 {
                public Step5 username(String username) {
                    MandatoryStages.this.builder.username(username);
                    return new Step5();
                }
            }

            public class Step3 {
                public Step4 userHandle(ByteArray userHandle) {
                    MandatoryStages.this.builder.userHandle(userHandle);
                    return new Step4();
                }
            }

            public class Step2 {
                public Step3 credentialId(ByteArray credentialId) {
                    MandatoryStages.this.builder.credentialId(credentialId);
                    return new Step3();
                }
            }
        }
    }
}

