/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2.impl;

import com.yubico.client.v2.ResponseStatus;
import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.YubicoClient;
import com.yubico.client.v2.exceptions.YubicoInvalidResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;

public class VerificationResponseImpl
implements VerificationResponse {
    private String h;
    private String t;
    private ResponseStatus status;
    private String timestamp;
    private String sessioncounter;
    private String sessionuse;
    private String sl;
    private String otp;
    private String nonce;
    private final Map<String, String> keyValueMap = new TreeMap<String, String>();

    public VerificationResponseImpl(InputStream inStream) throws IOException, YubicoInvalidResponse {
        String inputLine;
        if (inStream == null) {
            throw new IOException("InputStream argument was null");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        while ((inputLine = in.readLine()) != null) {
            int ix = inputLine.indexOf("=");
            if (ix == -1) continue;
            String key = inputLine.substring(0, ix);
            String val = inputLine.substring(ix + 1);
            if ("h".equals(key)) {
                this.h = val;
            } else if ("t".equals(key)) {
                this.t = val;
            } else if ("otp".equals(key)) {
                this.otp = val;
            } else if ("status".equals(key)) {
                this.status = ResponseStatus.valueOf(val);
            } else if ("timestamp".equals(key)) {
                this.timestamp = val;
            } else if ("sessioncounter".equals(key)) {
                this.sessioncounter = val;
            } else if ("sessionuse".equals(key)) {
                this.sessionuse = val;
            } else if ("sl".equals(key)) {
                this.sl = val;
            } else if ("nonce".equals(key)) {
                this.nonce = val;
            }
            this.keyValueMap.put(key, val);
        }
        in.close();
        if (this.status == null) {
            throw new YubicoInvalidResponse("Invalid response, contains no status.");
        }
    }

    @Override
    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    public String toString() {
        return this.otp + ":" + (Object)((Object)this.status);
    }

    @Override
    public boolean isOk() {
        return this.getStatus() == ResponseStatus.OK;
    }

    @Override
    public String getH() {
        return this.h;
    }

    @Override
    public String getT() {
        return this.t;
    }

    @Override
    public ResponseStatus getStatus() {
        return this.status;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getSessioncounter() {
        return this.sessioncounter;
    }

    @Override
    public String getSessionuse() {
        return this.sessionuse;
    }

    @Override
    public String getSl() {
        return this.sl;
    }

    @Override
    public String getOtp() {
        return this.otp;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public String getPublicId() {
        return YubicoClient.getPublicId(this.otp);
    }
}

