/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.OrgUnit;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.PredefinedAttributeInfos;
import org.identityconnectors.framework.common.objects.Uid;

public final class OrgunitsHandler {
    private static final Log LOG = Log.getLog(OrgunitsHandler.class);

    public static ObjectClassInfo getObjectClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsUtil.ORG_UNIT.getObjectClassValue());
        builder.setContainer(true);
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"parentOrgUnitPath").setRequired(true).build());
        builder.addAttributeInfo(PredefinedAttributeInfos.DESCRIPTION);
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"orgUnitPath"));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"blockInheritance", Boolean.class));
        return builder.build();
    }

    private static Optional<String> getOrgUnitNameFromPath(Name name) {
        if (null == name) {
            return Optional.empty();
        }
        String fullName = name.getNameValue();
        String[] elements = fullName.split("/");
        if (elements.length == 0) {
            return Optional.of(fullName);
        }
        return Optional.of(elements[elements.length - 1]);
    }

    private static String getParentOrgUnitPath(AttributesAccessor attributes) {
        String parentOrgUnitPath = attributes.findString("parentOrgUnitPath");
        if (StringUtil.isNotBlank((String)parentOrgUnitPath) && parentOrgUnitPath.charAt(0) != '/') {
            parentOrgUnitPath = "/" + parentOrgUnitPath;
        }
        if (StringUtil.isBlank((String)parentOrgUnitPath)) {
            throw new InvalidAttributeValueException("Missing required attribute 'parentOrgUnitPath'. The organization unit's parent path. Required when creating an orgunit.");
        }
        return parentOrgUnitPath;
    }

    public static Directory.Orgunits.Insert create(Directory.Orgunits service, AttributesAccessor attributes) {
        OrgUnit resource = new OrgUnit();
        resource.setParentOrgUnitPath(OrgunitsHandler.getParentOrgUnitPath(attributes));
        OrgunitsHandler.getOrgUnitNameFromPath(attributes.getName()).ifPresent(arg_0 -> ((OrgUnit)resource).setName(arg_0));
        resource.setBlockInheritance(attributes.findBoolean("blockInheritance"));
        resource.setDescription(attributes.findString("description"));
        try {
            return service.insert("my_customer", resource).setFields("orgUnitPath,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static void set(AtomicReference<OrgUnit> content, Consumer<OrgUnit> consumer) {
        if (content.get() == null) {
            content.set(new OrgUnit());
        }
        consumer.accept(content.get());
    }

    public static Directory.Orgunits.Patch update(Directory.Orgunits service, String orgUnitPath, AttributesAccessor attributes) {
        AtomicReference content = new AtomicReference();
        OrgunitsHandler.getOrgUnitNameFromPath(attributes.getName()).ifPresent(name -> OrgunitsHandler.set(content, o -> o.setName(name)));
        Optional.ofNullable(attributes.findString("parentOrgUnitPath")).ifPresent(ignore -> OrgunitsHandler.set(content, o -> o.setParentOrgUnitPath(OrgunitsHandler.getParentOrgUnitPath(attributes))));
        Optional.ofNullable(attributes.find("description")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> OrgunitsHandler.set(content, o -> o.setDescription(stringValue)));
        Optional.ofNullable(attributes.findBoolean("blockInheritance")).ifPresent(blockInheritance -> OrgunitsHandler.set(content, o -> o.setBlockInheritance(Boolean.valueOf(blockInheritance == false))));
        if (null == content.get()) {
            return null;
        }
        try {
            return service.patch("my_customer", orgUnitPath, (OrgUnit)content.get()).setFields("orgUnitPath,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Orgunits#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Orgunits.Update update(Directory.Orgunits service, String orgUnitPath, Set<AttributeDelta> modifications) {
        AtomicReference content = new AtomicReference();
        Optional.ofNullable(AttributeDeltaUtil.getAttributeDeltaForName(modifications)).map(AttributeDeltaUtil::getStringValue).flatMap(name -> OrgunitsHandler.getOrgUnitNameFromPath(new Name(name))).ifPresent(name -> OrgunitsHandler.set(content, o -> o.setName(name)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"parentOrgUnitPath", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> OrgunitsHandler.set(content, o -> o.setParentOrgUnitPath(stringValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"description", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> OrgunitsHandler.set(content, o -> o.setDescription(stringValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"blockInheritance", modifications)).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(blockInheritance -> OrgunitsHandler.set(content, o -> o.setBlockInheritance(Boolean.valueOf(blockInheritance == false))));
        if (null == content.get()) {
            return null;
        }
        try {
            return service.update("my_customer", orgUnitPath, (OrgUnit)content.get()).setFields("orgUnitPath,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Orgunits#update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject from(OrgUnit content, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsUtil.ORG_UNIT);
        builder.setUid(OrgunitsHandler.generateUid(content));
        builder.setName(content.getName());
        if (null == attributesToGet || attributesToGet.contains("description")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"description", (Object[])new Object[]{content.getDescription()})});
        }
        if (null == attributesToGet || attributesToGet.contains("orgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"orgUnitPath", (Object[])new Object[]{content.getOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("parentOrgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"parentOrgUnitPath", (Object[])new Object[]{content.getParentOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("blockInheritance")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"blockInheritance", (Object[])new Object[]{content.getBlockInheritance()})});
        }
        return builder.build();
    }

    public static Uid generateUid(OrgUnit content) {
        String orgUnitPath = content.getOrgUnitPath();
        if (orgUnitPath.startsWith("/")) {
            orgUnitPath = orgUnitPath.substring(1);
        }
        Uid uid = null != content.getEtag() ? new Uid(orgUnitPath, content.getEtag()) : new Uid(orgUnitPath);
        return uid;
    }

    private OrgunitsHandler() {
    }
}

