/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.spring.async;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SpringAsyncTaskExecutor
implements AsyncTaskExecutor {
    protected final AsyncListenableTaskExecutor asyncTaskExecutor;
    protected final boolean isAsyncTaskExecutorAopProxied;

    public SpringAsyncTaskExecutor(AsyncListenableTaskExecutor asyncTaskExecutor) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.isAsyncTaskExecutorAopProxied = AopUtils.isAopProxy((Object)asyncTaskExecutor);
    }

    public void execute(Runnable task) {
        this.asyncTaskExecutor.execute(task);
    }

    public CompletableFuture<?> submit(Runnable task) {
        return this.asyncTaskExecutor.submitListenable(task).completable();
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        return this.asyncTaskExecutor.submitListenable(task).completable();
    }

    public void shutdown() {
    }

    public AsyncListenableTaskExecutor getAsyncTaskExecutor() {
        return this.asyncTaskExecutor;
    }

    public int getRemainingCapacity() {
        Object executor = this.asyncTaskExecutor;
        if (this.isAsyncTaskExecutorAopProxied) {
            executor = AopProxyUtils.getSingletonTarget((Object)this.asyncTaskExecutor);
        }
        if (executor instanceof ThreadPoolTaskExecutor) {
            return ((ThreadPoolTaskExecutor)executor).getThreadPoolExecutor().getQueue().remainingCapacity();
        }
        return Integer.MAX_VALUE;
    }
}

