/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.SelectChoiceRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.SelectOption;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class CrontabPanel
extends Panel {
    private static final long serialVersionUID = 7879593326085337650L;
    private final AjaxTextFieldPanel seconds;
    private final AjaxTextFieldPanel minutes;
    private final AjaxTextFieldPanel hours;
    private final AjaxTextFieldPanel daysOfMonth;
    private final AjaxTextFieldPanel months;
    private final AjaxTextFieldPanel daysOfWeek;

    public CrontabPanel(String id, final PropertyModel<String> cronExpressionModel, String cronExpression) {
        super(id);
        this.setOutputMarkupId(true);
        final SelectOption[] cronTemplates = new SelectOption[]{new SelectOption(this.getString("selOpt1"), "UNSCHEDULE"), new SelectOption(this.getString("selOpt2"), "0 0/5 * * * ?"), new SelectOption(this.getString("selOpt3"), "0 0 12 * * ?"), new SelectOption(this.getString("selOpt4"), "0 0 0 1 * ?"), new SelectOption(this.getString("selOpt5"), "0 0 0 L * ?"), new SelectOption(this.getString("selOpt6"), "0 0 0 ? * 2")};
        AjaxDropDownChoicePanel cronTemplateChooser = new AjaxDropDownChoicePanel("cronTemplateChooser", "cronTemplateChooser", (IModel)new Model());
        cronTemplateChooser.setNullValid(false);
        cronTemplateChooser.setPlaceholder("chooseForTemplate");
        cronTemplateChooser.getField().setModel((IModel)new IModel<SelectOption>(){
            private static final long serialVersionUID = 6762568283146531315L;

            public SelectOption getObject() {
                SelectOption result = null;
                for (SelectOption so : cronTemplates) {
                    if (!so.getKeyValue().equals(cronExpressionModel.getObject())) continue;
                    result = so;
                }
                return result;
            }

            public void setObject(SelectOption object) {
                cronExpressionModel.setObject(object == null || object.equals((Object)cronTemplates[0]) ? null : object.toString());
            }

            public void detach() {
            }
        });
        cronTemplateChooser.setChoices(List.of(cronTemplates));
        cronTemplateChooser.setChoiceRenderer((IChoiceRenderer)new SelectChoiceRenderer());
        this.add(new Component[]{cronTemplateChooser});
        this.seconds = new AjaxTextFieldPanel("seconds", "seconds", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 0))));
        this.add(new Component[]{this.seconds.hideLabel()});
        this.minutes = new AjaxTextFieldPanel("minutes", "minutes", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 1))));
        this.add(new Component[]{this.minutes.hideLabel()});
        this.hours = new AjaxTextFieldPanel("hours", "hours", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 2))));
        this.add(new Component[]{this.hours.hideLabel()});
        this.daysOfMonth = new AjaxTextFieldPanel("daysOfMonth", "daysOfMonth", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 3))));
        this.add(new Component[]{this.daysOfMonth.hideLabel()});
        this.months = new AjaxTextFieldPanel("months", "months", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 4))));
        this.add(new Component[]{this.months.hideLabel()});
        this.daysOfWeek = new AjaxTextFieldPanel("daysOfWeek", "daysOfWeek", (IModel)new Model((Serializable)((Object)CrontabPanel.getCronField(cronExpression, 5))));
        this.add(new Component[]{this.daysOfWeek.hideLabel()});
        final FormComponent component = cronTemplateChooser.getField();
        cronTemplateChooser.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                CrontabPanel.this.seconds.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 0)));
                CrontabPanel.this.minutes.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 1)));
                CrontabPanel.this.hours.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 2)));
                CrontabPanel.this.daysOfMonth.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 3)));
                CrontabPanel.this.months.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 4)));
                CrontabPanel.this.daysOfWeek.setModelObject((Serializable)((Object)CrontabPanel.getCronField(component, 5)));
                target.add(new Component[]{CrontabPanel.this});
            }
        }});
    }

    private static String getCronField(FormComponent<?> formComponent, int field) {
        String cronField = null;
        if (formComponent != null) {
            cronField = CrontabPanel.getCronField(formComponent.getInput(), field);
        }
        return cronField;
    }

    private static String getCronField(String cron, int field) {
        String cronField = null;
        if (cron != null && !cron.isEmpty() && !"UNSCHEDULE".equals(cron)) {
            cronField = cron.split(" ")[field].trim();
        }
        return cronField;
    }

    public String getCronExpression() {
        String cronExpression = null;
        if (this.seconds != null && this.seconds.getModelObject() != null && this.minutes != null && this.minutes.getModelObject() != null && this.hours != null && this.hours.getModelObject() != null && this.daysOfMonth != null && this.daysOfMonth.getModelObject() != null && this.months != null && this.months.getModelObject() != null && this.daysOfWeek != null && this.daysOfWeek.getModelObject() != null) {
            cronExpression = ((String)((Object)this.seconds.getModelObject())).trim() + ' ' + ((String)((Object)this.minutes.getModelObject())).trim() + ' ' + ((String)((Object)this.hours.getModelObject())).trim() + ' ' + ((String)((Object)this.daysOfMonth.getModelObject())).trim() + ' ' + ((String)((Object)this.months.getModelObject())).trim() + ' ' + ((String)((Object)this.daysOfWeek.getModelObject())).trim();
        }
        return StringUtils.isNotBlank(cronExpression) ? cronExpression : null;
    }
}

