/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.okta;

import com.okta.authn.sdk.AuthenticationStateHandler;
import com.okta.authn.sdk.client.AuthenticationClient;
import com.okta.authn.sdk.resource.AuthenticationResponse;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.okta.OktaAuthenticationProperties;
import org.apereo.cas.okta.OktaAuthenticationStateHandlerAdapter;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaAuthenticationHandler.class);
    private final OktaAuthenticationProperties properties;
    private final AuthenticationClient oktaAuthenticationClient;

    public OktaAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, OktaAuthenticationProperties properties, AuthenticationClient oktaAuthenticationClient) {
        super(name, servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
        this.oktaAuthenticationClient = oktaAuthenticationClient;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        try {
            String username = credential.getUsername();
            OktaAuthenticationStateHandlerAdapter adapter = new OktaAuthenticationStateHandlerAdapter(this.getPasswordPolicyHandlingStrategy(), this.getPasswordPolicyConfiguration());
            AuthenticationResponse response = this.oktaAuthenticationClient.authenticate(username, credential.getPassword(), null, (AuthenticationStateHandler)adapter);
            Objects.requireNonNull(response, "Authentication response cannot be null");
            adapter.throwExceptionIfNecessary();
            LOGGER.debug("Created principal for id [{}] and [{}] attributes", (Object)adapter.getUsername(), adapter.getUserAttributes());
            Principal principal = this.principalFactory.createPrincipal(adapter.getUsername(), adapter.getUserAttributes());
            return this.createHandlerResult((Credential)credential, principal, adapter.getWarnings());
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException("Invalid credentials: " + e.getMessage());
        }
    }

    @Generated
    public OktaAuthenticationProperties getProperties() {
        return this.properties;
    }

    @Generated
    public AuthenticationClient getOktaAuthenticationClient() {
        return this.oktaAuthenticationClient;
    }
}

