/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class DropDownAlignmentBehavior
extends BootstrapBaseBehavior {
    private static final long serialVersionUID = 1L;
    private final IModel<Alignment> alignment;

    public DropDownAlignmentBehavior(IModel<Alignment> alignment) {
        this.alignment = (IModel)Args.notNull(alignment, (String)"alignment");
    }

    public DropDownAlignmentBehavior(Alignment alignment) {
        this((IModel<Alignment>)Model.of((Serializable)((Object)((Alignment)Args.notNull((Object)alignment, (String)"alignment")))));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.removeClass(tag, Alignment.RIGHT.cssClassName());
        Alignment value = (Alignment)this.alignment.getObject();
        switch (value) {
            case RIGHT: {
                Attributes.addClass(tag, value.cssClassName());
            }
        }
    }

    public DropDownAlignmentBehavior setAlignment(Alignment alignment) {
        this.alignment.setObject((Object)alignment);
        return this;
    }

    public void detach(Component component) {
        super.detach(component);
        this.alignment.detach();
    }

    public static enum Alignment implements ICssClassNameProvider
    {
        RIGHT("dropdown-menu-right"),
        NONE("");

        private String className;

        private Alignment(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

