/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http;

import com.okta.commons.http.RequestUtils;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class QueryString
extends TreeMap<String, String> {
    private static final long serialVersionUID = 42L;

    public QueryString() {
    }

    public QueryString(Map<String, ?> source) {
        if (!Collections.isEmpty(source)) {
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                this.put(entry.getKey(), this.getFormattedValue(entry.getValue()));
            }
        }
    }

    @Override
    public String put(String key, Object value) {
        if (value != null) {
            return super.put(key, this.getFormattedValue(value));
        }
        return null;
    }

    private String getFormattedValue(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof Date ? RequestUtils.getFormattedDate((Date)value) : String.valueOf(value);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean canonical) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            String key = RequestUtils.encodeUrl((String)entry.getKey(), false, canonical);
            String value = RequestUtils.encodeUrl((String)entry.getValue(), false, canonical);
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static QueryString create(String query) {
        String[] tokens;
        if (!Strings.hasLength((String)query)) {
            return null;
        }
        QueryString queryString = new QueryString();
        for (String token : tokens = Strings.tokenizeToStringArray((String)query, (String)"&", (boolean)false, (boolean)false)) {
            QueryString.applyKeyValuePair(queryString, token);
        }
        return queryString;
    }

    private static void applyKeyValuePair(QueryString qs, String kv) {
        String[] pair = Strings.split((String)kv, (String)"=");
        if (pair != null) {
            String key = pair[0];
            String value = pair[1] != null ? pair[1] : "";
            try {
                qs.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                qs.put(key, value);
            }
        } else {
            qs.put(kv, null);
        }
    }

    public static String buildHref(String href, QueryString qs) {
        StringBuilder sb = new StringBuilder(href);
        String query = qs.toString();
        if (!Strings.isEmpty((Object)query)) {
            sb.append('?').append(query);
        }
        return sb.toString();
    }
}

