/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.rpc;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.jobmaster.JobMasterOperatorEventGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.SerializedValue;

public class RpcTaskOperatorEventGateway
implements TaskOperatorEventGateway {
    private final JobMasterOperatorEventGateway rpcGateway;
    private final ExecutionAttemptID taskExecutionId;
    private final Consumer<Throwable> errorHandler;

    public RpcTaskOperatorEventGateway(JobMasterOperatorEventGateway rpcGateway, ExecutionAttemptID taskExecutionId, Consumer<Throwable> errorHandler) {
        this.rpcGateway = rpcGateway;
        this.taskExecutionId = taskExecutionId;
        this.errorHandler = errorHandler;
    }

    @Override
    public void sendOperatorEventToCoordinator(OperatorID operator, SerializedValue<OperatorEvent> event) {
        CompletableFuture<Acknowledge> result = this.rpcGateway.sendOperatorEventToCoordinator(this.taskExecutionId, operator, event);
        result.whenComplete((success, exception) -> {
            if (exception != null) {
                this.errorHandler.accept((Throwable)exception);
            }
        });
    }
}

