/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.CURLBuilder;
import org.apache.streampark.common.util.ReflectUtils;
import org.apache.streampark.console.base.util.Tuple2;
import org.apache.streampark.console.core.annotation.OpenAPI;
import org.apache.streampark.console.core.bean.OpenAPISchema;
import org.apache.streampark.console.core.controller.OpenAPIController;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class OpenAPIComponent {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIComponent.class);
    @Autowired
    private AccessTokenService accessTokenService;
    @Autowired
    private ServiceHelper serviceHelper;
    private final Map<String, String> types = new HashMap<String, String>();
    private final Map<String, OpenAPISchema> schemas = new HashMap<String, OpenAPISchema>();

    public synchronized OpenAPISchema getOpenAPISchema(String name) {
        if (this.schemas.isEmpty()) {
            try {
                this.initOpenAPISchema();
            }
            catch (Exception e) {
                log.error("InitOpenAPISchema failed", (Throwable)e);
            }
        }
        return this.schemas.get(name);
    }

    public String getOpenApiCUrl(String name, String baseUrl, Long appId, Long teamId) {
        OpenAPISchema schema = this.getOpenAPISchema(name);
        if (schema == null) {
            throw new UnsupportedOperationException("Unsupported OpenAPI: " + name);
        }
        String url = schema.getUrl();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{baseUrl})) {
            url = baseUrl + url;
        }
        CURLBuilder curlBuilder = new CURLBuilder(url);
        curlBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").addHeader("Authorization", this.accessTokenService.getByUserId(this.serviceHelper.getUserId()).getToken());
        schema.getSchema().forEach(c -> {
            if (c.isRequired()) {
                if (c.getBindFor().equals("appId")) {
                    curlBuilder.addFormData(c.getName(), (Serializable)appId);
                }
            } else {
                curlBuilder.addFormData(c.getName(), (Serializable)((Object)c.getDefaultValue()));
            }
        });
        return curlBuilder.build();
    }

    private void initOpenAPISchema() {
        this.initTypes();
        Class<OpenAPIController> clazz = OpenAPIController.class;
        RequestMapping requestMapping = clazz.getDeclaredAnnotation(RequestMapping.class);
        String basePath = requestMapping.value()[0];
        List methodList = ReflectUtils.getMethodsByAnnotation(clazz, OpenAPI.class);
        for (Method method : methodList) {
            OpenAPISchema detail = new OpenAPISchema();
            ArrayList<OpenAPISchema.Schema> headerList = new ArrayList<OpenAPISchema.Schema>();
            OpenAPI openAPI = method.getDeclaredAnnotation(OpenAPI.class);
            for (OpenAPI.Param header : openAPI.header()) {
                headerList.add(this.paramToSchema(header));
            }
            ArrayList<OpenAPISchema.Schema> paramList = new ArrayList<OpenAPISchema.Schema>();
            for (OpenAPI.Param param : openAPI.param()) {
                paramList.add(this.paramToSchema(param));
            }
            detail.setSchema(paramList);
            detail.setHeader(headerList);
            Tuple2<String, String[]> methodURI = this.getMethodAndRequestURI(method);
            String[] requestURI = (String[])methodURI.t2;
            String uri = requestURI != null && requestURI.length > 0 ? requestURI[0] : "";
            String restURI = "/" + basePath;
            if (uri != null) {
                restURI = restURI + "/" + uri;
            }
            restURI = restURI.replaceAll("/+", "/").replaceAll("/$", "");
            detail.setUrl(restURI);
            detail.setMethod((String)methodURI.t1);
            this.schemas.put(openAPI.name(), detail);
        }
    }

    private OpenAPISchema.Schema paramToSchema(OpenAPI.Param param) {
        OpenAPISchema.Schema schema = new OpenAPISchema.Schema();
        schema.setName(param.name());
        if (StringUtils.isBlank((CharSequence)param.bindFor())) {
            schema.setBindFor(param.name());
        } else {
            schema.setBindFor(param.bindFor());
        }
        schema.setRequired(param.required());
        schema.setDescription(param.description());
        schema.setDefaultValue(param.defaultValue());
        String type = this.types.get(param.type().getSimpleName());
        if (type != null) {
            schema.setType(type);
        } else {
            schema.setType("string(" + param.type().getSimpleName() + ")");
        }
        return schema;
    }

    private Tuple2<String, String[]> getMethodAndRequestURI(Method method) {
        method.setAccessible(true);
        GetMapping getMapping = method.getDeclaredAnnotation(GetMapping.class);
        if (getMapping != null) {
            return Tuple2.of(HttpMethod.GET.name(), getMapping.value());
        }
        PostMapping postMapping = method.getDeclaredAnnotation(PostMapping.class);
        if (postMapping != null) {
            return Tuple2.of(HttpMethod.POST.name(), postMapping.value());
        }
        DeleteMapping deleteMapping = method.getDeclaredAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            return Tuple2.of(HttpMethod.DELETE.name(), deleteMapping.value());
        }
        PatchMapping patchMapping = method.getDeclaredAnnotation(PatchMapping.class);
        if (patchMapping != null) {
            return Tuple2.of(HttpMethod.PATCH.name(), patchMapping.value());
        }
        PutMapping putMapping = method.getDeclaredAnnotation(PutMapping.class);
        if (putMapping != null) {
            return Tuple2.of(HttpMethod.PUT.name(), putMapping.value());
        }
        throw new IllegalArgumentException("get http method and requestURI failed: " + method.getName());
    }

    private void initTypes() {
        this.types.put("String", "string");
        this.types.put("int", "integer(int32)");
        this.types.put("Integer", "integer(int32)");
        this.types.put("Short", "integer(int32)");
        this.types.put("long", "integer(int64)");
        this.types.put("Long", "integer(int64)");
        this.types.put("double", "number(double)");
        this.types.put("Double", "number(double)");
        this.types.put("float", "number(float)");
        this.types.put("Float", "number(float)");
        this.types.put("boolean", "boolean");
        this.types.put("Boolean", "boolean");
        this.types.put("byte", "string(byte)");
        this.types.put("Byte", "string(byte)");
        this.types.put("Date", "string(date)");
        this.types.put("DateTime", "string(datetime)");
    }
}

