/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.xdr.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrFieldInfo;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.AbstractXdrType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.XdrType;

public abstract class XdrStructType
extends AbstractXdrType<XdrStructType> {
    private XdrFieldInfo[] fieldInfos;
    private XdrType[] fields;

    public XdrStructType(XdrDataType xdrDataType) {
        super(xdrDataType);
        this.fieldInfos = null;
        this.fields = null;
    }

    public XdrStructType(XdrDataType xdrDataType, XdrFieldInfo[] fieldInfos) {
        super(xdrDataType);
        if (fieldInfos != null) {
            this.fieldInfos = (XdrFieldInfo[])fieldInfos.clone();
            this.fields = new XdrType[fieldInfos.length];
            this.getStructTypeInstance(this.fields, fieldInfos);
        } else {
            this.fieldInfos = null;
            this.fields = null;
        }
    }

    protected abstract void getStructTypeInstance(XdrType[] var1, XdrFieldInfo[] var2);

    public XdrFieldInfo[] getXdrFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        int allLen = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            AbstractXdrType field = (AbstractXdrType)this.fields[i];
            if (field == null) continue;
            allLen += field.encodingLength();
        }
        return allLen;
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.fields.length; ++i) {
            XdrType field = this.fields[i];
            if (field == null) continue;
            field.encode(buffer);
        }
    }

    @Override
    public void decode(ByteBuffer content) throws IOException {
        AbstractXdrType[] fields = this.getAllFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            fields[i].decode(content);
            int length = fields[i].encodingLength();
            byte[] array = content.array();
            byte[] newArray = new byte[array.length - length];
            System.arraycopy(array, length, newArray, 0, array.length - length);
            content = ByteBuffer.wrap(newArray);
        }
        this.fields = fields;
        this.setValue(this.fieldsToValues(fields));
    }

    protected abstract XdrStructType fieldsToValues(AbstractXdrType[] var1);

    protected abstract AbstractXdrType[] getAllFields();
}

