/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.MemorySize;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.InternalConfigHolder;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.util.CompletableFutureUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.FileUtils;
import org.apache.streampark.console.base.util.GZipUtils;
import org.apache.streampark.console.base.util.GitUtils;
import org.apache.streampark.console.base.util.ObjectUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.BuildState;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.mapper.ProjectMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.ProjectService;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.console.core.task.ProjectBuildTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ProjectServiceImpl
extends ServiceImpl<ProjectMapper, Project>
implements ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    @Value(value="${streampark.project.max-build:6}")
    public Long maxProjectBuildNum;
    private static final int CPU_NUM = Math.max(4, Runtime.getRuntime().availableProcessors() * 2);
    private final ExecutorService projectBuildExecutor = new ThreadPoolExecutor(CPU_NUM, CPU_NUM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-project-build"));

    @Override
    public RestResponse create(Project project) {
        RestResponse response = RestResponse.success();
        project.setId(null);
        ApiAlertException.throwIfTrue(this.checkExists(project), "project name already exists, add project failed");
        Date date = new Date();
        project.setCreateTime(date);
        project.setModifyTime(date);
        boolean status = this.save(project);
        if (status) {
            return response.message("Add project successfully").data(true);
        }
        return response.message("Add project failed").data(false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(Project projectParam) {
        Project project = (Project)this.getById(projectParam.getId());
        Utils.notNull((Object)project);
        ApiAlertException.throwIfFalse(project.getTeamId().equals(projectParam.getTeamId()), "Team can't be changed, update project failed.");
        ApiAlertException.throwIfFalse(!project.getBuildState().equals(BuildState.BUILDING.get()), "The project is being built, update project failed.");
        project.setName(projectParam.getName());
        project.setUrl(projectParam.getUrl());
        project.setRefs(projectParam.getRefs());
        project.setPrvkeyPath(projectParam.getPrvkeyPath());
        project.setUserName(projectParam.getUserName());
        project.setPassword(projectParam.getPassword());
        project.setPom(projectParam.getPom());
        project.setDescription(projectParam.getDescription());
        project.setBuildArgs(projectParam.getBuildArgs());
        project.setModifyTime(new Date());
        if (GitUtils.isSshRepositoryUrl(project.getUrl())) {
            project.setUserName(null);
        } else {
            project.setPrvkeyPath(null);
        }
        if (projectParam.getBuildState() != null) {
            project.setBuildState(projectParam.getBuildState());
            if (BuildState.of(projectParam.getBuildState()).equals(BuildState.NEED_REBUILD)) {
                List<Application> applications = this.getApplications(project);
                applications.forEach(app -> {
                    log.info("update deploy by project: {}, appName:{}", (Object)project.getName(), (Object)app.getJobName());
                    app.setRelease(ReleaseState.NEED_CHECK.get());
                    this.applicationService.updateRelease((Application)app);
                });
            }
        }
        ((ProjectMapper)this.baseMapper).updateById(project);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(Long id) {
        Project project = (Project)this.getById(id);
        Utils.notNull((Object)project);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Application::getProjectId, (Object)id);
        long count = this.applicationService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            return false;
        }
        try {
            project.delete();
            this.removeById(id);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public IPage<Project> page(Project project, RestRequest request) {
        Page page = MybatisPager.getPage(request);
        return ((ProjectMapper)this.baseMapper).page(page, project);
    }

    @Override
    public Boolean existsByTeamId(Long teamId) {
        return ((ProjectMapper)this.baseMapper).existsByTeamId(teamId);
    }

    @Override
    public List<Project> findByTeamId(Long teamId) {
        return ((ProjectMapper)this.baseMapper).selectByTeamId(teamId);
    }

    @Override
    public void build(Long id) throws Exception {
        Long currentBuildCount = ((ProjectMapper)this.baseMapper).getBuildingCount();
        ApiAlertException.throwIfTrue(this.maxProjectBuildNum > -1L && currentBuildCount > this.maxProjectBuildNum, String.format("The number of running Build projects exceeds the maximum number: %d of max-build-num", this.maxProjectBuildNum));
        Project project = (Project)this.getById(id);
        ((ProjectMapper)this.baseMapper).updateBuildState(project.getId(), BuildState.BUILDING.get());
        String logPath = this.getBuildLogPath(id);
        ProjectBuildTask projectBuildTask = new ProjectBuildTask(logPath, project, buildState -> {
            ((ProjectMapper)this.baseMapper).updateBuildState(id, buildState.get());
            if (buildState == BuildState.SUCCESSFUL) {
                ((ProjectMapper)this.baseMapper).updateBuildTime(id);
            }
            this.flinkAppHttpWatcher.initialize();
        }, fileLogger -> {
            List<Application> applications = this.applicationService.getByProjectId(project.getId());
            applications.forEach(app -> {
                fileLogger.info("update deploy by project: {}, appName:{}", (Object)project.getName(), (Object)app.getJobName());
                app.setRelease(ReleaseState.NEED_RELEASE.get());
                app.setBuild(true);
                this.applicationService.updateRelease((Application)app);
            });
            this.flinkAppHttpWatcher.initialize();
        });
        CompletableFuture<Void> buildTask = CompletableFuture.runAsync(projectBuildTask, this.projectBuildExecutor);
        CompletableFutureUtils.runTimeout(buildTask, (long)20L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Override
    public List<String> modules(Long id) {
        Project project = (Project)this.getById(id);
        Utils.notNull((Object)project);
        BuildState buildState = BuildState.of(project.getBuildState());
        if (BuildState.SUCCESSFUL.equals(buildState)) {
            File appHome = project.getDistHome();
            if (appHome.exists()) {
                ArrayList<String> list = new ArrayList<String>();
                Object[] files = appHome.listFiles();
                if (CommonUtils.notEmpty(files).booleanValue()) {
                    for (Object file : files) {
                        list.add(((File)file).getName());
                    }
                }
                return list;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> jars(Project project) {
        ArrayList<String> list = new ArrayList<String>(0);
        ApiAlertException.throwIfNull(project.getModule(), "Project module can't be null, please check.");
        File apps = new File(project.getDistHome(), project.getModule());
        for (File file : Objects.requireNonNull(apps.listFiles())) {
            if (!file.getName().endsWith(".jar")) continue;
            list.add(file.getName());
        }
        return list;
    }

    @Override
    public String getAppConfPath(Long id, String module) {
        Project project = (Project)this.getById(id);
        File appHome = project.getDistHome();
        File[] files = appHome.listFiles();
        if (!appHome.exists() || files == null) {
            return null;
        }
        Optional<File> fileOptional = Arrays.stream(files).filter(x -> x.getName().equals(module)).findFirst();
        return fileOptional.map(File::getAbsolutePath).orElse(null);
    }

    @Override
    public List<Application> getApplications(Project project) {
        return this.applicationService.getByProjectId(project.getId());
    }

    @Override
    public boolean checkExists(Project project) {
        Project proj;
        if (project.getId() != null && (proj = (Project)this.getById(project.getId())) != null && ObjectUtils.safeEquals(project.getName(), proj.getName())) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getName, (Object)project.getName())).eq(Project::getTeamId, (Object)project.getTeamId());
        return ((ProjectMapper)this.baseMapper).selectCount((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public List<String> getAllBranches(Project project) {
        try {
            GitUtils.GitGetRequest request = new GitUtils.GitGetRequest();
            request.setUrl(project.getUrl());
            request.setUsername(project.getUserName());
            request.setPassword(project.getPassword());
            request.setPrivateKey(project.getPrvkeyPath());
            return GitUtils.getBranches(request);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    @Override
    public GitAuthorizedError gitCheck(Project project) {
        try {
            GitUtils.GitGetRequest request = new GitUtils.GitGetRequest();
            request.setUrl(project.getUrl());
            request.setUsername(project.getUserName());
            request.setPassword(project.getPassword());
            request.setPrivateKey(project.getPrvkeyPath());
            GitUtils.getBranches(request);
            return GitAuthorizedError.SUCCESS;
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (err.contains("not authorized")) {
                return GitAuthorizedError.ERROR;
            }
            if (err.contains("Authentication is required")) {
                return GitAuthorizedError.REQUIRED;
            }
            return GitAuthorizedError.UNKNOW;
        }
    }

    @Override
    public List<String> getAllTags(Project project) {
        try {
            GitUtils.GitGetRequest request = new GitUtils.GitGetRequest();
            request.setUrl(project.getUrl());
            request.setUsername(project.getUserName());
            request.setPassword(project.getPassword());
            request.setPrivateKey(project.getPrvkeyPath());
            return GitUtils.getTags(request);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    @Override
    public List<Map<String, Object>> listConf(Project project) {
        try {
            File file = new File(project.getDistHome(), project.getModule());
            File unzipFile = new File(file.getAbsolutePath().replaceAll(".tar.gz", ""));
            if (!unzipFile.exists()) {
                GZipUtils.decompress(file.getAbsolutePath(), file.getParentFile().getAbsolutePath());
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            File[] files = unzipFile.listFiles(x -> "conf".equals(x.getName()));
            Utils.notNull((Object)files);
            for (File item : files) {
                this.eachFile(item, list, true);
            }
            return list;
        }
        catch (Exception e) {
            log.error("List conf Failed!", (Throwable)e);
            log.error(e.getMessage());
            return null;
        }
    }

    private void eachFile(File file, List<Map<String, Object>> list, Boolean isRoot) {
        if (file != null && file.exists() && file.listFiles() != null) {
            if (isRoot.booleanValue()) {
                HashMap<String, Object> map = new HashMap<String, Object>(0);
                map.put("key", file.getName());
                map.put("title", file.getName());
                map.put("value", file.getAbsolutePath());
                ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                this.eachFile(file, children, false);
                if (!children.isEmpty()) {
                    map.put("children", children);
                }
                list.add(map);
            } else {
                for (File item : Objects.requireNonNull(file.listFiles())) {
                    String title = item.getName();
                    String value = item.getAbsolutePath();
                    HashMap<String, Object> map = new HashMap<String, Object>(0);
                    map.put("key", title);
                    map.put("title", title);
                    map.put("value", value);
                    ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                    this.eachFile(item, children, false);
                    if (!children.isEmpty()) {
                        map.put("children", children);
                    }
                    list.add(map);
                }
            }
        }
    }

    @Override
    public RestResponse getBuildLog(Long id, Long startOffset) {
        File logFile = Paths.get(this.getBuildLogPath(id), new String[0]).toFile();
        if (!logFile.exists()) {
            String errorMsg = String.format("Build log file(fileName=%s) not found, please build first.", logFile);
            log.warn(errorMsg);
            return RestResponse.success().data(errorMsg);
        }
        boolean isBuilding = ((Project)this.getById(id)).getBuildState() == 0;
        long endOffset = 0L;
        boolean readFinished = true;
        if (startOffset == null && isBuilding) {
            startOffset = 0L;
        }
        try {
            byte[] fileContent;
            long maxSize = MemorySize.parse((String)((String)InternalConfigHolder.get((InternalOption)CommonConfig.READ_LOG_MAX_SIZE()))).getBytes();
            if (startOffset == null) {
                fileContent = FileUtils.readEndOfFile(logFile, maxSize);
            } else {
                fileContent = FileUtils.readFileFromOffset(logFile, startOffset, maxSize);
                endOffset = startOffset + (long)fileContent.length;
                readFinished = logFile.length() == endOffset && !isBuilding;
            }
            return RestResponse.success().data(new String(fileContent, StandardCharsets.UTF_8)).put("offset", (Object)endOffset).put("readFinished", (Object)readFinished);
        }
        catch (IOException e) {
            String error = String.format("Read build log file(fileName=%s) caused an exception: ", logFile);
            log.error(error, (Throwable)e);
            return RestResponse.fail(error + e.getMessage(), ResponseCode.CODE_FAIL);
        }
    }

    private String getBuildLogPath(Long projectId) {
        return String.format("%s/%s/build.log", Workspace.PROJECT_BUILD_LOG_PATH(), projectId);
    }
}

