/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.enums;

import java.io.Serializable;
import java.util.Arrays;

public enum ChangedType implements Serializable
{
    NONE(0),
    DEPENDENCY(1),
    SQL(2),
    ALL(3);

    private final int value;

    private ChangedType(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    public static ChangedType of(Integer value) {
        return Arrays.stream(ChangedType.values()).filter(x -> x.value == value).findFirst().orElse(null);
    }

    public boolean noChanged() {
        return this.equals(NONE);
    }

    public boolean hasChanged() {
        return !this.noChanged();
    }

    public boolean isDependencyChanged() {
        return this.equals(ALL) || this.equals(DEPENDENCY);
    }

    public String toString() {
        switch (this) {
            case NONE: {
                return "[NONE], nothing to changed";
            }
            case DEPENDENCY: {
                return "[DEPENDENCY], Dependency is changed";
            }
            case SQL: {
                return "[SQL], Flink Sql is changed";
            }
            case ALL: {
                return "[ALL], Dependency and Flink Sql all changed";
            }
        }
        return null;
    }
}

