/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.HadoopUtils$;
import org.apache.streampark.common.util.HttpClientUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class YarnUtils$
implements Logger {
    public static YarnUtils$ MODULE$;
    private String PROXY_YARN_URL;
    private boolean hasYarnHttpKerberosAuth;
    private boolean hasYarnHttpSimpleAuth;
    private String rmHttpURL;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new YarnUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private String PROXY_YARN_URL$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PROXY_YARN_URL = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_PROXY_YARN_URL());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PROXY_YARN_URL;
    }

    public String PROXY_YARN_URL() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PROXY_YARN_URL$lzycompute() : this.PROXY_YARN_URL;
    }

    private boolean hasYarnHttpKerberosAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpKerberosAuth = "kerberos".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hasYarnHttpKerberosAuth;
    }

    public boolean hasYarnHttpKerberosAuth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hasYarnHttpKerberosAuth$lzycompute() : this.hasYarnHttpKerberosAuth;
    }

    private boolean hasYarnHttpSimpleAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpSimpleAuth = "simple".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hasYarnHttpSimpleAuth;
    }

    public boolean hasYarnHttpSimpleAuth() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hasYarnHttpSimpleAuth$lzycompute() : this.hasYarnHttpSimpleAuth;
    }

    public List<ApplicationId> getAppId(String appName) {
        Buffer buffer;
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.RUNNING, YarnApplicationState.ACCEPTED, YarnApplicationState.SUBMITTED);
        try {
            buffer = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(HadoopUtils$.MODULE$.yarnClient().getApplications(appStates)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)YarnUtils$.$anonfun$getAppId$1(appName, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getApplicationId(), Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            e.printStackTrace();
            buffer = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
        Buffer appIds = buffer;
        return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)appIds.toList());
    }

    /*
     * WARNING - void declaration
     */
    public YarnApplicationState getState(String appId) {
        void var3_5;
        YarnApplicationState yarnApplicationState;
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appId);
        try {
            ApplicationReport applicationReport = HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId);
            yarnApplicationState = applicationReport.getYarnApplicationState();
        }
        catch (Exception e) {
            e.printStackTrace();
            yarnApplicationState = null;
        }
        YarnApplicationState state = yarnApplicationState;
        return var3_5;
    }

    public boolean isContains(String appName) {
        List runningApps = HadoopUtils$.MODULE$.yarnClient().getApplications(EnumSet.of(YarnApplicationState.RUNNING));
        return runningApps != null ? JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(runningApps).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)YarnUtils$.$anonfun$isContains$1(appName, x$3))) : false;
    }

    public String getRMWebAppProxyURL() {
        return StringUtils.isNotBlank((CharSequence)this.PROXY_YARN_URL()) ? this.PROXY_YARN_URL() : this.getRMWebAppURL(this.getRMWebAppURL$default$1());
    }

    public String getRMWebAppURL(boolean getLatest) {
        if (!getLatest && this.rmHttpURL != null) {
            return this.rmHttpURL;
        }
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            Tuple3 tuple3;
            Configuration conf = HadoopUtils$.MODULE$.hadoopConf();
            Tuple3 tuple32 = tuple3 = YarnConfiguration.useHttps((Configuration)conf) ? new Tuple3((Object)"yarn.resourcemanager.webapp.https.address", (Object)BoxesRunTime.boxToInteger((int)8090), (Object)"https://") : new Tuple3((Object)"yarn.resourcemanager.webapp.address", (Object)BoxesRunTime.boxToInteger((int)8088), (Object)"http://");
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String webConfKey = (String)tuple3._1();
            int defaultPort = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String protocol = (String)tuple3._3();
            Tuple3 tuple33 = new Tuple3((Object)webConfKey, (Object)BoxesRunTime.boxToInteger((int)defaultPort), (Object)protocol);
            Tuple3 tuple34 = tuple33;
            String webConfKey2 = (String)tuple34._1();
            int defaultPort2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
            String protocol2 = (String)tuple34._3();
            this.rmHttpURL = new StringBuilder(0).append(protocol2).append(Option$.MODULE$.apply((Object)conf.get("yarn.web-proxy.address", null)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String string;
                String addrKey = !HAUtil.isHAEnabled((Configuration)conf) ? webConfKey2 : this.getAddressConfKey$1(conf, webConfKey2, protocol2, defaultPort2);
                InetSocketAddress socketAddr = conf.getSocketAddr(addrKey, new StringBuilder(8).append("0.0.0.0:").append(defaultPort2).toString(), defaultPort2);
                InetSocketAddress address = NetUtils.getConnectAddress((InetSocketAddress)socketAddr);
                InetAddress resolved = address.getAddress();
                if (resolved != null && !resolved.isAnyLocalAddress() && !resolved.isLoopbackAddress()) {
                    string = address.getHostName();
                } else {
                    String string2;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getCanonicalHostName());
                    if (try_ instanceof Success) {
                        String value;
                        Success success = (Success)try_;
                        string2 = value = (String)success.value();
                    } else {
                        string2 = address.getHostName();
                    }
                    string = string2;
                }
                String hostName = string;
                return new StringBuilder(1).append(hostName).append(":").append(address.getPort()).toString();
            })).toString();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("yarn resourceManager webapp url:").append(YarnUtils$.MODULE$.rmHttpURL).toString());
        }
        return this.rmHttpURL;
    }

    public boolean getRMWebAppURL$default$1() {
        return false;
    }

    public String getYarnAppTrackingUrl(ApplicationId applicationId) {
        return HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId).getTrackingUrl();
    }

    public String restRequest(String url, int timeout) throws IOException {
        String string;
        if (url == null) {
            return null;
        }
        String string2 = url;
        if (string2.matches("^http(|s)://.*")) {
            String v;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.request(url, timeout));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.hasYarnHttpKerberosAuth()) {
                        throw new IOException(new StringBuilder(48).append("yarnUtils authRestRequest error, url: ").append(string2).append(", detail: ").append(e).toString());
                    }
                    throw new IOException(new StringBuilder(44).append("yarnUtils restRequest error, url: ").append(string2).append(", detail: ").append(e).toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            String string3 = v = (String)success.value();
            string = string3;
        } else {
            String string4;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.request(new StringBuilder(1).append(MODULE$.getRMWebAppURL(MODULE$.getRMWebAppURL$default$1())).append("/").append(url).toString(), timeout));
            if (try_ instanceof Success) {
                String v;
                Success success = (Success)try_;
                string4 = v = (String)success.value();
            } else if (try_ instanceof Failure) {
                String v;
                Try try_2 = Utils$.MODULE$.retry(5, Utils$.MODULE$.retry$default$2(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.request(new StringBuilder(1).append(MODULE$.getRMWebAppURL(true)).append("/").append(url).toString(), timeout));
                if (!(try_2 instanceof Success)) {
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        throw new IOException(new StringBuilder(56).append("yarnUtils restRequest retry 5 times all failed. detail: ").append(e).toString());
                    }
                    throw new MatchError(try_2);
                }
                Success success = (Success)try_2;
                String string5 = v = (String)success.value();
                string4 = string5;
            } else {
                throw new MatchError((Object)try_);
            }
            string = string4;
        }
        return string;
    }

    public int restRequest$default$2() {
        return 5000;
    }

    private String request(String reqUrl, int timeout) {
        String string;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).build();
        if (this.hasYarnHttpKerberosAuth()) {
            string = (String)HadoopUtils$.MODULE$.getUgi().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(reqUrl, config){
                private final String reqUrl$1;
                private final RequestConfig config$1;

                public String run() {
                    return HttpClientUtils$.MODULE$.httpAuthGetRequest(this.reqUrl$1, this.config$1);
                }
                {
                    this.reqUrl$1 = reqUrl$1;
                    this.config$1 = config$1;
                }
            });
        } else {
            String url = !this.hasYarnHttpSimpleAuth() ? reqUrl : new StringBuilder(11).append(reqUrl).append("?user.name=").append(HadoopUtils$.MODULE$.hadoopUserName()).toString();
            string = HttpClientUtils$.MODULE$.httpGetRequest(url, config);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getAppId$1(String appName$1, ApplicationReport x$1) {
        String string = x$1.getName();
        String string2 = appName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isContains$1(String appName$2, ApplicationReport x$3) {
        String string = x$3.getName();
        String string2 = appName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getRMWebAppURL$3(String protocol$1, Configuration conf$1, String webConfKey$1, int defaultPort$1, int rpcTimeoutForChecks$1, String id) {
        String url = new StringBuilder(0).append(protocol$1).append(Option$.MODULE$.apply((Object)conf$1.get(HAUtil.addSuffix((String)webConfKey$1, (String)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String hostname = conf$1.get(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)id));
            return new StringBuilder(1).append(hostname).append(":").append(defaultPort$1).toString();
        })).toString();
        return HttpClientUtils$.MODULE$.tryCheckUrl(url, rpcTimeoutForChecks$1);
    }

    private final String findActiveRMId$1(YarnConfiguration yarnConf, Configuration conf$1, String protocol$1, String webConfKey$1, int defaultPort$1) {
        String string;
        Option option = Option$.MODULE$.apply((Object)RMHAUtils.findActiveRMHAId((Configuration)yarnConf));
        if (option instanceof Some) {
            Some some = (Some)option;
            String rmId = (String)some.value();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "findActiveRMHAId successful");
            string = rmId;
        } else {
            this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("findActiveRMHAId is null, config yarn.acl.enable:").append(yarnConf.get("yarn.acl.enable")).append(",now http try it.").toString());
            int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
            string = (String)JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(HAUtil.getRMHAIds((Configuration)conf$1)).find((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)YarnUtils$.$anonfun$getRMWebAppURL$3(protocol$1, conf$1, webConfKey$1, defaultPort$1, rpcTimeoutForChecks, id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IOException("[StreamPark] YarnUtils.getRMWebAppURL: can not found yarn active node");
            });
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getAddressConfKey$1(Configuration conf$1, String webConfKey$1, String protocol$1, int defaultPort$1) {
        YarnConfiguration yarnConf = new YarnConfiguration(conf$1);
        String activeRMId = this.findActiveRMId$1(yarnConf, conf$1, protocol$1, webConfKey$1, defaultPort$1);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("current activeRMHAId: ").append(activeRMId).toString());
        String activeRMKey = HAUtil.addSuffix((String)webConfKey$1, (String)activeRMId);
        String hostRMKey = HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)activeRMId);
        Tuple2 tuple2 = new Tuple2((Object)activeRMKey, (Object)hostRMKey);
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String host = (String)tuple2._2();
            if (HAUtil.getConfValueForRMInstance((String)key, (Configuration)yarnConf) == null && HAUtil.getConfValueForRMInstance((String)host, (Configuration)yarnConf) != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Find rm web address by : ").append(host).toString());
                return host;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Find rm web address by : ").append(key).toString());
        return key;
    }

    private YarnUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

