/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.VersionMismatchException;
import org.apache.flink.core.io.Versioned;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public abstract class VersionedIOReadableWritable
implements IOReadableWritable,
Versioned {
    private int readVersion = Integer.MIN_VALUE;

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.getVersion());
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.readVersion = in.readInt();
        this.resolveVersionRead(this.readVersion);
    }

    public int getReadVersion() {
        return this.readVersion == Integer.MIN_VALUE ? this.getVersion() : this.readVersion;
    }

    public int[] getCompatibleVersions() {
        return new int[]{this.getVersion()};
    }

    private void resolveVersionRead(int readVersion) throws VersionMismatchException {
        int[] compatibleVersions;
        for (int compatibleVersion : compatibleVersions = this.getCompatibleVersions()) {
            if (compatibleVersion != readVersion) continue;
            return;
        }
        throw new VersionMismatchException("Incompatible version: found " + readVersion + ", compatible versions are " + Arrays.toString(compatibleVersions));
    }
}

