/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.console.core.enums.LoginType;
import org.apache.streampark.console.core.enums.UserType;

@TableName(value="t_user")
public class User
implements Serializable {
    private static final long serialVersionUID = -4852732617765810959L;
    public static final String STATUS_VALID = "1";
    public static final String STATUS_LOCK = "0";
    public static final String SEX_MALE = "0";
    public static final String SEX_FEMALE = "1";
    public static final String SEX_UNKNOWN = "2";
    public static final Integer DEFAULT_PASSWORD_LENGTH = 8;
    @TableId(type=IdType.AUTO)
    private Long userId;
    @Size(min=4, max=20, message="{range}")
    private @Size(min=4, max=20, message="{range}") String username;
    private String password;
    @Size(max=50, message="{noMoreThan}")
    @Email(message="{email}")
    private @Size(max=50, message="{noMoreThan}") @Email(message="{email}") String email;
    private UserType userType;
    private LoginType loginType;
    @NotBlank(message="{required}")
    private @NotBlank(message="{required}") String status;
    private Date createTime;
    private Date modifyTime;
    private Date lastLoginTime;
    @NotBlank(message="{required}")
    private @NotBlank(message="{required}") String sex;
    @Size(max=100, message="{noMoreThan}")
    private @Size(max=100, message="{noMoreThan}") String description;
    private transient String oldPassword;
    private transient String sortField;
    private transient String sortOrder;
    private transient String createTimeFrom;
    private transient String createTimeTo;
    private transient String id;
    private String salt;
    private String nickName;
    private Long lastTeamId;

    public void dataMasking() {
        String dataMask = ConfigConst.DEFAULT_DATAMASK_STRING();
        this.setPassword(dataMask);
        this.setSalt(dataMask);
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getSex() {
        return this.sex;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public String getCreateTimeFrom() {
        return this.createTimeFrom;
    }

    public String getCreateTimeTo() {
        return this.createTimeTo;
    }

    public String getId() {
        return this.id;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getNickName() {
        return this.nickName;
    }

    public Long getLastTeamId() {
        return this.lastTeamId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setCreateTimeFrom(String createTimeFrom) {
        this.createTimeFrom = createTimeFrom;
    }

    public void setCreateTimeTo(String createTimeTo) {
        this.createTimeTo = createTimeTo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setLastTeamId(Long lastTeamId) {
        this.lastTeamId = lastTeamId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Long this$lastTeamId = this.getLastTeamId();
        Long other$lastTeamId = other.getLastTeamId();
        if (this$lastTeamId == null ? other$lastTeamId != null : !((Object)this$lastTeamId).equals(other$lastTeamId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        UserType this$userType = this.getUserType();
        UserType other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)((Object)this$userType)).equals((Object)other$userType)) {
            return false;
        }
        LoginType this$loginType = this.getLoginType();
        LoginType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !((Object)((Object)this$loginType)).equals((Object)other$loginType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        Date this$lastLoginTime = this.getLastLoginTime();
        Date other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !((Object)this$lastLoginTime).equals(other$lastLoginTime)) {
            return false;
        }
        String this$sex = this.getSex();
        String other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        return !(this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Long $lastTeamId = this.getLastTeamId();
        result = result * 59 + ($lastTeamId == null ? 43 : ((Object)$lastTeamId).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        UserType $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)((Object)$userType)).hashCode());
        LoginType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : ((Object)((Object)$loginType)).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        Date $lastLoginTime = this.getLastLoginTime();
        result = result * 59 + ($lastLoginTime == null ? 43 : ((Object)$lastLoginTime).hashCode());
        String $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        return result;
    }

    public String toString() {
        return "User(userId=" + this.getUserId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", userType=" + (Object)((Object)this.getUserType()) + ", loginType=" + (Object)((Object)this.getLoginType()) + ", status=" + this.getStatus() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", lastLoginTime=" + this.getLastLoginTime() + ", sex=" + this.getSex() + ", description=" + this.getDescription() + ", oldPassword=" + this.getOldPassword() + ", sortField=" + this.getSortField() + ", sortOrder=" + this.getSortOrder() + ", createTimeFrom=" + this.getCreateTimeFrom() + ", createTimeTo=" + this.getCreateTimeTo() + ", id=" + this.getId() + ", salt=" + this.getSalt() + ", nickName=" + this.getNickName() + ", lastTeamId=" + this.getLastTeamId() + ")";
    }
}

