/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.StateSnapshotTransformer;

public class StateSnapshotTransformers {

    public static abstract class StateSnapshotTransformFactoryWrapAdaptor<S, T>
    implements StateSnapshotTransformer.StateSnapshotTransformFactory<T> {
        final StateSnapshotTransformer.StateSnapshotTransformFactory<S> originalSnapshotTransformFactory;

        StateSnapshotTransformFactoryWrapAdaptor(StateSnapshotTransformer.StateSnapshotTransformFactory<S> originalSnapshotTransformFactory) {
            this.originalSnapshotTransformFactory = originalSnapshotTransformFactory;
        }

        @Override
        public Optional<StateSnapshotTransformer<T>> createForDeserializedState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MapStateSnapshotTransformFactory<K, V>
    extends StateSnapshotTransformFactoryWrapAdaptor<V, Map<K, V>> {
        public MapStateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<V> originalSnapshotTransformFactory) {
            super(originalSnapshotTransformFactory);
        }

        @Override
        public Optional<StateSnapshotTransformer<Map<K, V>>> createForDeserializedState() {
            return this.originalSnapshotTransformFactory.createForDeserializedState().map(MapStateSnapshotTransformer::new);
        }
    }

    public static class MapStateSnapshotTransformer<K, V>
    implements StateSnapshotTransformer<Map<K, V>> {
        private final StateSnapshotTransformer<V> entryValueTransformer;

        public MapStateSnapshotTransformer(StateSnapshotTransformer<V> entryValueTransformer) {
            this.entryValueTransformer = entryValueTransformer;
        }

        @Override
        @Nullable
        public Map<K, V> filterOrTransform(@Nullable Map<K, V> map) {
            if (map == null) {
                return null;
            }
            HashMap<K, V> transformedMap = new HashMap<K, V>();
            boolean anyChange = false;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                V transformedValue = this.entryValueTransformer.filterOrTransform(entry.getValue());
                if (transformedValue != null) {
                    transformedMap.put(entry.getKey(), transformedValue);
                }
                anyChange |= transformedValue == null || !Objects.equals(entry.getValue(), transformedValue);
            }
            return anyChange ? (transformedMap.isEmpty() ? null : transformedMap) : map;
        }
    }

    public static class ListStateSnapshotTransformFactory<T>
    extends StateSnapshotTransformFactoryWrapAdaptor<T, List<T>> {
        public ListStateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<T> originalSnapshotTransformFactory) {
            super(originalSnapshotTransformFactory);
        }

        @Override
        public Optional<StateSnapshotTransformer<List<T>>> createForDeserializedState() {
            return this.originalSnapshotTransformFactory.createForDeserializedState().map(ListStateSnapshotTransformer::new);
        }
    }

    public static class ListStateSnapshotTransformer<T>
    implements StateSnapshotTransformer<List<T>> {
        private final StateSnapshotTransformer<T> entryValueTransformer;
        private final StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy transformStrategy;

        public ListStateSnapshotTransformer(StateSnapshotTransformer<T> entryValueTransformer) {
            this.entryValueTransformer = entryValueTransformer;
            this.transformStrategy = entryValueTransformer instanceof StateSnapshotTransformer.CollectionStateSnapshotTransformer ? ((StateSnapshotTransformer.CollectionStateSnapshotTransformer)entryValueTransformer).getFilterStrategy() : StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy.TRANSFORM_ALL;
        }

        @Override
        @Nullable
        public List<T> filterOrTransform(@Nullable List<T> list) {
            if (list == null) {
                return null;
            }
            List<T> transformedList = new ArrayList<T>();
            boolean anyChange = false;
            for (int i = 0; i < list.size(); ++i) {
                T entry = list.get(i);
                T transformedEntry = this.entryValueTransformer.filterOrTransform(entry);
                if (transformedEntry != null) {
                    if (this.transformStrategy == StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy.STOP_ON_FIRST_INCLUDED) {
                        transformedList = list.subList(i, list.size());
                        anyChange = i > 0;
                        break;
                    }
                    transformedList.add(transformedEntry);
                }
                anyChange |= transformedEntry == null || !Objects.equals(entry, transformedEntry);
            }
            transformedList = anyChange ? transformedList : list;
            return transformedList.isEmpty() ? null : transformedList;
        }
    }
}

