/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Message;
import org.apache.streampark.console.core.enums.NoticeType;
import org.apache.streampark.console.core.mapper.MessageMapper;
import org.apache.streampark.console.core.service.MessageService;
import org.apache.streampark.console.core.websocket.WebSocketEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class MessageServiceImpl
extends ServiceImpl<MessageMapper, Message>
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);

    @Override
    public void push(Message message) {
        this.save(message);
        WebSocketEndpoint.pushNotice(message);
    }

    @Override
    public IPage<Message> getUnRead(NoticeType noticeType, RestRequest request) {
        Page page = new MybatisPager().getDefaultPage(request);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Message::getIsRead, (Object)false)).orderByDesc(Message::getCreateTime)).eq(Message::getType, (Object)noticeType.get());
        return ((MessageMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
    }
}

