/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.conf.K8sFlinkConfig;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.enums.ApplicationType;
import org.apache.streampark.common.enums.DevelopmentMode;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.common.enums.StorageType;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.common.util.FileUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.base.util.ObjectUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.bean.AppControl;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.enums.ResourceFrom;
import org.apache.streampark.console.core.metrics.flink.JobsOverview;
import org.apache.streampark.console.core.utils.YarnQueueLabelExpression;
import org.apache.streampark.flink.kubernetes.model.K8sPodTemplates;
import org.apache.streampark.flink.packer.maven.Artifact;
import org.apache.streampark.flink.packer.maven.DependencyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_app")
public class Application
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long teamId;
    private Integer jobType;
    private Long projectId;
    private Long userId;
    private String jobName;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String appId;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String jobId;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String jobManagerUrl;
    private Long versionId;
    private String clusterId;
    private String flinkImage;
    private String k8sNamespace = K8sFlinkConfig.DEFAULT_KUBERNETES_NAMESPACE();
    private Integer state;
    @TableField(value="`release`")
    private Integer release;
    private Boolean build;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private Integer restartSize;
    private Integer restartCount;
    private Integer optionState;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private Integer alertId;
    private String args;
    private String module;
    private String options;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String hotParams;
    private Integer resolveOrder;
    private Integer executionMode;
    private String dynamicProperties;
    private Integer appType;
    private Integer tracking;
    private String jar;
    private Long jarCheckSum;
    private String mainClass;
    private Date startTime;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private Date endTime;
    private Long duration;
    private Integer cpMaxFailureInterval;
    private Integer cpFailureRateInterval;
    private Integer cpFailureAction;
    @TableField(value="TOTAL_TM")
    private Integer totalTM;
    private Integer totalSlot;
    private Integer availableSlot;
    private Integer jmMemory;
    private Integer tmMemory;
    private Integer totalTask;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private Long flinkClusterId;
    private String description;
    private Date createTime;
    private Date optionTime;
    private Date modifyTime;
    private Integer k8sRestExposedType;
    private String k8sPodTemplate;
    private String k8sJmPodTemplate;
    private String k8sTmPodTemplate;
    private String ingressTemplate;
    private String defaultModeIngress;
    private Integer resourceFrom;
    private Boolean k8sHadoopIntegration;
    private String tags;
    private transient JobsOverview.Task overview;
    private transient String dependency;
    private transient Long sqlId;
    private transient String flinkSql;
    private transient Integer[] stateArray;
    private transient Integer[] jobTypeArray;
    private transient Boolean backUp = false;
    private transient Boolean restart = false;
    private transient String userName;
    private transient String nickName;
    private transient String config;
    private transient Long configId;
    private transient String flinkVersion;
    private transient String confPath;
    private transient Integer format;
    private transient String savePoint;
    private transient Boolean savePointed = false;
    private transient Boolean drain = false;
    private transient Long savePointTimeout = 60L;
    private transient Boolean allowNonRestored = false;
    private transient String socketId;
    private transient String projectName;
    private transient String createTimeFrom;
    private transient String createTimeTo;
    private transient String backUpDescription;
    private transient String yarnQueue;
    private transient String flinkRestUrl;
    private transient Integer buildStatus;
    private transient AppControl appControl;

    public String getIngressTemplate() {
        return this.ingressTemplate;
    }

    public void setIngressTemplate(String ingressTemplate) {
        this.ingressTemplate = ingressTemplate;
    }

    public String getDefaultModeIngress() {
        return this.defaultModeIngress;
    }

    public void setDefaultModeIngress(String defaultModeIngress) {
        this.defaultModeIngress = defaultModeIngress;
    }

    public void setK8sNamespace(String k8sNamespace) {
        this.k8sNamespace = StringUtils.isBlank((CharSequence)k8sNamespace) ? K8sFlinkConfig.DEFAULT_KUBERNETES_NAMESPACE() : k8sNamespace;
    }

    public K8sPodTemplates getK8sPodTemplates() {
        return K8sPodTemplates.of((String)this.k8sPodTemplate, (String)this.k8sJmPodTemplate, (String)this.k8sTmPodTemplate);
    }

    public void setState(Integer state) {
        this.state = state;
        FlinkAppState appState = FlinkAppState.of(this.state);
        this.tracking = Application.shouldTracking(appState);
    }

    public void setYarnQueueByHotParams() {
        if (ExecutionMode.YARN_APPLICATION != this.getExecutionModeEnum() && ExecutionMode.YARN_PER_JOB != this.getExecutionModeEnum()) {
            return;
        }
        Map<String, Object> hotParamsMap = this.getHotParamsMap();
        if (!hotParamsMap.isEmpty() && hotParamsMap.containsKey(ConfigConst.KEY_YARN_APP_QUEUE())) {
            String yarnQueue = hotParamsMap.get(ConfigConst.KEY_YARN_APP_QUEUE()).toString();
            String labelExpr = Optional.ofNullable(hotParamsMap.get(ConfigConst.KEY_YARN_APP_NODE_LABEL())).map(Object::toString).orElse(null);
            this.setYarnQueue(YarnQueueLabelExpression.of(yarnQueue, labelExpr).toString());
        }
    }

    public static Integer shouldTracking(@Nonnull FlinkAppState state) {
        switch (state) {
            case ADDED: 
            case CREATED: 
            case FINISHED: 
            case FAILED: 
            case CANCELED: 
            case TERMINATED: 
            case POS_TERMINATED: 
            case LOST: {
                return 0;
            }
        }
        return 1;
    }

    public boolean isCanBeStart() {
        FlinkAppState state = FlinkAppState.of(this.getState());
        switch (state) {
            case ADDED: 
            case CREATED: 
            case FINISHED: 
            case FAILED: 
            case CANCELED: 
            case TERMINATED: 
            case POS_TERMINATED: 
            case LOST: 
            case SUCCEEDED: 
            case KILLED: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldBeTrack() {
        return Application.shouldTracking(FlinkAppState.of(this.getState())) == 1;
    }

    @JsonIgnore
    public ReleaseState getReleaseState() {
        return ReleaseState.of(this.release);
    }

    @JsonIgnore
    public DevelopmentMode getDevelopmentMode() {
        return DevelopmentMode.of((Integer)this.jobType);
    }

    @JsonIgnore
    public void setDevelopmentMode(DevelopmentMode mode) {
        this.jobType = mode.getValue();
    }

    @JsonIgnore
    public FlinkAppState getFlinkAppStateEnum() {
        return FlinkAppState.of(this.state);
    }

    @JsonIgnore
    public FlinkK8sRestExposedType getK8sRestExposedTypeEnum() {
        return FlinkK8sRestExposedType.of((Integer)this.k8sRestExposedType);
    }

    @JsonIgnore
    public ExecutionMode getExecutionModeEnum() {
        return ExecutionMode.of((Integer)this.executionMode);
    }

    public boolean cpFailedTrigger() {
        return this.cpMaxFailureInterval != null && this.cpFailureRateInterval != null && this.cpFailureAction != null;
    }

    public boolean eqFlinkJob(Application other) {
        if (this.isFlinkSqlJob() && other.isFlinkSqlJob() && this.getFlinkSql().trim().equals(other.getFlinkSql().trim())) {
            return this.getDependencyObject().eq(other.getDependencyObject());
        }
        return false;
    }

    @JsonIgnore
    public String getDistHome() {
        String path = String.format("%s/%s/%s", Workspace.APP_LOCAL_DIST(), this.projectId.toString(), this.getModule());
        log.info("local distHome:{}", (Object)path);
        return path;
    }

    @JsonIgnore
    public String getLocalAppHome() {
        String path = String.format("%s/%s", Workspace.local().APP_WORKSPACE(), this.id.toString());
        log.info("local appHome:{}", (Object)path);
        return path;
    }

    @JsonIgnore
    public String getRemoteAppHome() {
        String path = String.format("%s/%s", Workspace.remote().APP_WORKSPACE(), this.id.toString());
        log.info("remote appHome:{}", (Object)path);
        return path;
    }

    @JsonIgnore
    public String getAppHome() {
        switch (this.getExecutionModeEnum()) {
            case KUBERNETES_NATIVE_APPLICATION: 
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_PER_JOB: 
            case YARN_SESSION: 
            case REMOTE: 
            case LOCAL: {
                return this.getLocalAppHome();
            }
            case YARN_APPLICATION: {
                return this.getRemoteAppHome();
            }
        }
        throw new UnsupportedOperationException("unsupported executionMode ".concat(this.getExecutionModeEnum().getName()));
    }

    @JsonIgnore
    public String getAppLib() {
        return this.getAppHome().concat("/lib");
    }

    @JsonIgnore
    public ApplicationType getApplicationType() {
        return ApplicationType.of((int)this.appType);
    }

    @JsonIgnore
    public Map<String, Object> getOptionMap() {
        if (StringUtils.isBlank((CharSequence)this.options)) {
            return Collections.emptyMap();
        }
        Map map = JacksonUtils.read(this.options, Map.class);
        map.entrySet().removeIf(entry -> entry.getValue() == null);
        return map;
    }

    @JsonIgnore
    public boolean isFlinkSqlJob() {
        return DevelopmentMode.FLINK_SQL.getValue().equals(this.getJobType());
    }

    @JsonIgnore
    public boolean isCustomCodeJob() {
        return DevelopmentMode.CUSTOM_CODE.getValue().equals(this.getJobType());
    }

    @JsonIgnore
    public boolean isUploadJob() {
        return this.isCustomCodeJob() && ResourceFrom.UPLOAD.getValue().equals(this.getResourceFrom());
    }

    @JsonIgnore
    public boolean isCICDJob() {
        return this.isCustomCodeJob() && ResourceFrom.CICD.getValue().equals(this.getResourceFrom());
    }

    public boolean isStreamParkJob() {
        return this.getAppType().intValue() == ApplicationType.STREAMPARK_FLINK.getType();
    }

    @JsonIgnore
    public Dependency getDependencyObject() {
        return Dependency.toDependency(this.dependency);
    }

    @JsonIgnore
    public DependencyInfo getDependencyInfo() {
        return Dependency.toDependency(this.getDependency()).toJarPackDeps();
    }

    @JsonIgnore
    public boolean isRunning() {
        return FlinkAppState.RUNNING.getValue() == this.getState().intValue();
    }

    @JsonIgnore
    public boolean isNeedRollback() {
        return ReleaseState.NEED_ROLLBACK.get() == this.getRelease().intValue();
    }

    @JsonIgnore
    public boolean isNeedRestartOnFailed() {
        if (this.restartSize != null && this.restartCount != null) {
            return this.restartSize > 0 && this.restartCount <= this.restartSize;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean eqJobParam(Application other) {
        if (!ObjectUtils.safeEquals(this.getVersionId(), other.getVersionId())) {
            return false;
        }
        if (!ObjectUtils.safeEquals(this.getResolveOrder(), other.getResolveOrder())) return false;
        if (!ObjectUtils.safeEquals(this.getExecutionMode(), other.getExecutionMode())) return false;
        if (!ObjectUtils.safeEquals(this.getK8sRestExposedType(), other.getK8sRestExposedType())) {
            return false;
        }
        if (this.getOptions() != null) {
            if (other.getOptions() == null) return false;
            if (!this.getOptions().trim().equals(other.getOptions().trim())) {
                Map<String, Object> optMap = this.getOptionMap();
                Map<String, Object> otherMap = other.getOptionMap();
                if (optMap.size() != otherMap.size()) {
                    return false;
                }
                for (Map.Entry<String, Object> entry : optMap.entrySet()) {
                    if (entry.getValue().equals(otherMap.get(entry.getKey()))) continue;
                    return false;
                }
            }
        } else if (other.getOptions() != null) {
            return false;
        }
        if (this.getDynamicProperties() != null) {
            if (other.getDynamicProperties() == null) return false;
            if (!this.getDynamicProperties().trim().equals(other.getDynamicProperties().trim())) {
                return false;
            }
        } else if (other.getDynamicProperties() != null) {
            return false;
        }
        if (this.getArgs() != null) {
            if (other.getArgs() == null) return false;
            return this.getArgs().trim().equals(other.getArgs().trim());
        }
        if (other.getArgs() != null) return false;
        return true;
    }

    @JsonIgnore
    public StorageType getStorageType() {
        return Application.getStorageType(this.getExecutionMode());
    }

    public static StorageType getStorageType(Integer execMode) {
        ExecutionMode executionMode = ExecutionMode.of((Integer)execMode);
        switch (Objects.requireNonNull(executionMode)) {
            case YARN_APPLICATION: {
                return StorageType.HDFS;
            }
            case KUBERNETES_NATIVE_APPLICATION: 
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_PER_JOB: 
            case YARN_SESSION: 
            case REMOTE: {
                return StorageType.LFS;
            }
        }
        throw new UnsupportedOperationException("Unsupported ".concat(executionMode.getName()));
    }

    @JsonIgnore
    public FsOperator getFsOperator() {
        return FsOperator.of((StorageType)this.getStorageType());
    }

    @JsonIgnore
    public Workspace getWorkspace() {
        return Workspace.of((StorageType)this.getStorageType());
    }

    @JsonIgnore
    public Map<String, Object> getHotParamsMap() {
        if (this.hotParams != null) {
            Map map = JacksonUtils.read(this.hotParams, Map.class);
            map.entrySet().removeIf(entry -> entry.getValue() == null);
            return map;
        }
        return Collections.EMPTY_MAP;
    }

    public void doSetHotParams() {
        this.updateHotParams(this);
    }

    public void updateHotParams(Application appParam) {
        if (appParam != this) {
            this.hotParams = null;
        }
        ExecutionMode executionModeEnum = appParam.getExecutionModeEnum();
        HashMap<String, String> hotParams = new HashMap<String, String>(0);
        if (this.needFillYarnQueueLabel(executionModeEnum)) {
            hotParams.putAll(YarnQueueLabelExpression.getQueueLabelMap(appParam.getYarnQueue()));
        }
        if (!hotParams.isEmpty()) {
            this.setHotParams(JacksonUtils.write(hotParams));
        }
    }

    private boolean needFillYarnQueueLabel(ExecutionMode mode) {
        return ExecutionMode.YARN_PER_JOB.equals((Object)mode) || ExecutionMode.YARN_APPLICATION.equals((Object)mode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Application)o).id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public Integer getJobType() {
        return this.jobType;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobManagerUrl() {
        return this.jobManagerUrl;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getFlinkImage() {
        return this.flinkImage;
    }

    public String getK8sNamespace() {
        return this.k8sNamespace;
    }

    public Integer getState() {
        return this.state;
    }

    public Integer getRelease() {
        return this.release;
    }

    public Boolean getBuild() {
        return this.build;
    }

    public Integer getRestartSize() {
        return this.restartSize;
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public Integer getOptionState() {
        return this.optionState;
    }

    public Integer getAlertId() {
        return this.alertId;
    }

    public String getArgs() {
        return this.args;
    }

    public String getModule() {
        return this.module;
    }

    public String getOptions() {
        return this.options;
    }

    public String getHotParams() {
        return this.hotParams;
    }

    public Integer getResolveOrder() {
        return this.resolveOrder;
    }

    public Integer getExecutionMode() {
        return this.executionMode;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public Integer getTracking() {
        return this.tracking;
    }

    public String getJar() {
        return this.jar;
    }

    public Long getJarCheckSum() {
        return this.jarCheckSum;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Integer getCpMaxFailureInterval() {
        return this.cpMaxFailureInterval;
    }

    public Integer getCpFailureRateInterval() {
        return this.cpFailureRateInterval;
    }

    public Integer getCpFailureAction() {
        return this.cpFailureAction;
    }

    public Integer getTotalTM() {
        return this.totalTM;
    }

    public Integer getTotalSlot() {
        return this.totalSlot;
    }

    public Integer getAvailableSlot() {
        return this.availableSlot;
    }

    public Integer getJmMemory() {
        return this.jmMemory;
    }

    public Integer getTmMemory() {
        return this.tmMemory;
    }

    public Integer getTotalTask() {
        return this.totalTask;
    }

    public Long getFlinkClusterId() {
        return this.flinkClusterId;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getOptionTime() {
        return this.optionTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Integer getK8sRestExposedType() {
        return this.k8sRestExposedType;
    }

    public String getK8sPodTemplate() {
        return this.k8sPodTemplate;
    }

    public String getK8sJmPodTemplate() {
        return this.k8sJmPodTemplate;
    }

    public String getK8sTmPodTemplate() {
        return this.k8sTmPodTemplate;
    }

    public Integer getResourceFrom() {
        return this.resourceFrom;
    }

    public Boolean getK8sHadoopIntegration() {
        return this.k8sHadoopIntegration;
    }

    public String getTags() {
        return this.tags;
    }

    public JobsOverview.Task getOverview() {
        return this.overview;
    }

    public String getDependency() {
        return this.dependency;
    }

    public Long getSqlId() {
        return this.sqlId;
    }

    public String getFlinkSql() {
        return this.flinkSql;
    }

    public Integer[] getStateArray() {
        return this.stateArray;
    }

    public Integer[] getJobTypeArray() {
        return this.jobTypeArray;
    }

    public Boolean getBackUp() {
        return this.backUp;
    }

    public Boolean getRestart() {
        return this.restart;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getConfig() {
        return this.config;
    }

    public Long getConfigId() {
        return this.configId;
    }

    public String getFlinkVersion() {
        return this.flinkVersion;
    }

    public String getConfPath() {
        return this.confPath;
    }

    public Integer getFormat() {
        return this.format;
    }

    public String getSavePoint() {
        return this.savePoint;
    }

    public Boolean getSavePointed() {
        return this.savePointed;
    }

    public Boolean getDrain() {
        return this.drain;
    }

    public Long getSavePointTimeout() {
        return this.savePointTimeout;
    }

    public Boolean getAllowNonRestored() {
        return this.allowNonRestored;
    }

    public String getSocketId() {
        return this.socketId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getCreateTimeFrom() {
        return this.createTimeFrom;
    }

    public String getCreateTimeTo() {
        return this.createTimeTo;
    }

    public String getBackUpDescription() {
        return this.backUpDescription;
    }

    public String getYarnQueue() {
        return this.yarnQueue;
    }

    public String getFlinkRestUrl() {
        return this.flinkRestUrl;
    }

    public Integer getBuildStatus() {
        return this.buildStatus;
    }

    public AppControl getAppControl() {
        return this.appControl;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobManagerUrl(String jobManagerUrl) {
        this.jobManagerUrl = jobManagerUrl;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setFlinkImage(String flinkImage) {
        this.flinkImage = flinkImage;
    }

    public void setRelease(Integer release) {
        this.release = release;
    }

    public void setBuild(Boolean build) {
        this.build = build;
    }

    public void setRestartSize(Integer restartSize) {
        this.restartSize = restartSize;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public void setOptionState(Integer optionState) {
        this.optionState = optionState;
    }

    public void setAlertId(Integer alertId) {
        this.alertId = alertId;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setHotParams(String hotParams) {
        this.hotParams = hotParams;
    }

    public void setResolveOrder(Integer resolveOrder) {
        this.resolveOrder = resolveOrder;
    }

    public void setExecutionMode(Integer executionMode) {
        this.executionMode = executionMode;
    }

    public void setDynamicProperties(String dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public void setTracking(Integer tracking) {
        this.tracking = tracking;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setJarCheckSum(Long jarCheckSum) {
        this.jarCheckSum = jarCheckSum;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setCpMaxFailureInterval(Integer cpMaxFailureInterval) {
        this.cpMaxFailureInterval = cpMaxFailureInterval;
    }

    public void setCpFailureRateInterval(Integer cpFailureRateInterval) {
        this.cpFailureRateInterval = cpFailureRateInterval;
    }

    public void setCpFailureAction(Integer cpFailureAction) {
        this.cpFailureAction = cpFailureAction;
    }

    public void setTotalTM(Integer totalTM) {
        this.totalTM = totalTM;
    }

    public void setTotalSlot(Integer totalSlot) {
        this.totalSlot = totalSlot;
    }

    public void setAvailableSlot(Integer availableSlot) {
        this.availableSlot = availableSlot;
    }

    public void setJmMemory(Integer jmMemory) {
        this.jmMemory = jmMemory;
    }

    public void setTmMemory(Integer tmMemory) {
        this.tmMemory = tmMemory;
    }

    public void setTotalTask(Integer totalTask) {
        this.totalTask = totalTask;
    }

    public void setFlinkClusterId(Long flinkClusterId) {
        this.flinkClusterId = flinkClusterId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setOptionTime(Date optionTime) {
        this.optionTime = optionTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setK8sRestExposedType(Integer k8sRestExposedType) {
        this.k8sRestExposedType = k8sRestExposedType;
    }

    public void setK8sPodTemplate(String k8sPodTemplate) {
        this.k8sPodTemplate = k8sPodTemplate;
    }

    public void setK8sJmPodTemplate(String k8sJmPodTemplate) {
        this.k8sJmPodTemplate = k8sJmPodTemplate;
    }

    public void setK8sTmPodTemplate(String k8sTmPodTemplate) {
        this.k8sTmPodTemplate = k8sTmPodTemplate;
    }

    public void setResourceFrom(Integer resourceFrom) {
        this.resourceFrom = resourceFrom;
    }

    public void setK8sHadoopIntegration(Boolean k8sHadoopIntegration) {
        this.k8sHadoopIntegration = k8sHadoopIntegration;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setOverview(JobsOverview.Task overview) {
        this.overview = overview;
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public void setSqlId(Long sqlId) {
        this.sqlId = sqlId;
    }

    public void setFlinkSql(String flinkSql) {
        this.flinkSql = flinkSql;
    }

    public void setStateArray(Integer[] stateArray) {
        this.stateArray = stateArray;
    }

    public void setJobTypeArray(Integer[] jobTypeArray) {
        this.jobTypeArray = jobTypeArray;
    }

    public void setBackUp(Boolean backUp) {
        this.backUp = backUp;
    }

    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public void setFlinkVersion(String flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public void setConfPath(String confPath) {
        this.confPath = confPath;
    }

    public void setFormat(Integer format) {
        this.format = format;
    }

    public void setSavePoint(String savePoint) {
        this.savePoint = savePoint;
    }

    public void setSavePointed(Boolean savePointed) {
        this.savePointed = savePointed;
    }

    public void setDrain(Boolean drain) {
        this.drain = drain;
    }

    public void setSavePointTimeout(Long savePointTimeout) {
        this.savePointTimeout = savePointTimeout;
    }

    public void setAllowNonRestored(Boolean allowNonRestored) {
        this.allowNonRestored = allowNonRestored;
    }

    public void setSocketId(String socketId) {
        this.socketId = socketId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setCreateTimeFrom(String createTimeFrom) {
        this.createTimeFrom = createTimeFrom;
    }

    public void setCreateTimeTo(String createTimeTo) {
        this.createTimeTo = createTimeTo;
    }

    public void setBackUpDescription(String backUpDescription) {
        this.backUpDescription = backUpDescription;
    }

    public void setYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
    }

    public void setFlinkRestUrl(String flinkRestUrl) {
        this.flinkRestUrl = flinkRestUrl;
    }

    public void setBuildStatus(Integer buildStatus) {
        this.buildStatus = buildStatus;
    }

    public void setAppControl(AppControl appControl) {
        this.appControl = appControl;
    }

    public String toString() {
        return "Application(id=" + this.getId() + ", teamId=" + this.getTeamId() + ", jobType=" + this.getJobType() + ", projectId=" + this.getProjectId() + ", userId=" + this.getUserId() + ", jobName=" + this.getJobName() + ", appId=" + this.getAppId() + ", jobId=" + this.getJobId() + ", jobManagerUrl=" + this.getJobManagerUrl() + ", versionId=" + this.getVersionId() + ", clusterId=" + this.getClusterId() + ", flinkImage=" + this.getFlinkImage() + ", k8sNamespace=" + this.getK8sNamespace() + ", state=" + this.getState() + ", release=" + this.getRelease() + ", build=" + this.getBuild() + ", restartSize=" + this.getRestartSize() + ", restartCount=" + this.getRestartCount() + ", optionState=" + this.getOptionState() + ", alertId=" + this.getAlertId() + ", args=" + this.getArgs() + ", module=" + this.getModule() + ", options=" + this.getOptions() + ", hotParams=" + this.getHotParams() + ", resolveOrder=" + this.getResolveOrder() + ", executionMode=" + this.getExecutionMode() + ", dynamicProperties=" + this.getDynamicProperties() + ", appType=" + this.getAppType() + ", tracking=" + this.getTracking() + ", jar=" + this.getJar() + ", jarCheckSum=" + this.getJarCheckSum() + ", mainClass=" + this.getMainClass() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ", cpMaxFailureInterval=" + this.getCpMaxFailureInterval() + ", cpFailureRateInterval=" + this.getCpFailureRateInterval() + ", cpFailureAction=" + this.getCpFailureAction() + ", totalTM=" + this.getTotalTM() + ", totalSlot=" + this.getTotalSlot() + ", availableSlot=" + this.getAvailableSlot() + ", jmMemory=" + this.getJmMemory() + ", tmMemory=" + this.getTmMemory() + ", totalTask=" + this.getTotalTask() + ", flinkClusterId=" + this.getFlinkClusterId() + ", description=" + this.getDescription() + ", createTime=" + this.getCreateTime() + ", optionTime=" + this.getOptionTime() + ", modifyTime=" + this.getModifyTime() + ", k8sRestExposedType=" + this.getK8sRestExposedType() + ", k8sPodTemplate=" + this.getK8sPodTemplate() + ", k8sJmPodTemplate=" + this.getK8sJmPodTemplate() + ", k8sTmPodTemplate=" + this.getK8sTmPodTemplate() + ", ingressTemplate=" + this.getIngressTemplate() + ", defaultModeIngress=" + this.getDefaultModeIngress() + ", resourceFrom=" + this.getResourceFrom() + ", k8sHadoopIntegration=" + this.getK8sHadoopIntegration() + ", tags=" + this.getTags() + ", overview=" + this.getOverview() + ", dependency=" + this.getDependency() + ", sqlId=" + this.getSqlId() + ", flinkSql=" + this.getFlinkSql() + ", stateArray=" + Arrays.deepToString(this.getStateArray()) + ", jobTypeArray=" + Arrays.deepToString(this.getJobTypeArray()) + ", backUp=" + this.getBackUp() + ", restart=" + this.getRestart() + ", userName=" + this.getUserName() + ", nickName=" + this.getNickName() + ", config=" + this.getConfig() + ", configId=" + this.getConfigId() + ", flinkVersion=" + this.getFlinkVersion() + ", confPath=" + this.getConfPath() + ", format=" + this.getFormat() + ", savePoint=" + this.getSavePoint() + ", savePointed=" + this.getSavePointed() + ", drain=" + this.getDrain() + ", savePointTimeout=" + this.getSavePointTimeout() + ", allowNonRestored=" + this.getAllowNonRestored() + ", socketId=" + this.getSocketId() + ", projectName=" + this.getProjectName() + ", createTimeFrom=" + this.getCreateTimeFrom() + ", createTimeTo=" + this.getCreateTimeTo() + ", backUpDescription=" + this.getBackUpDescription() + ", yarnQueue=" + this.getYarnQueue() + ", flinkRestUrl=" + this.getFlinkRestUrl() + ", buildStatus=" + this.getBuildStatus() + ", appControl=" + this.getAppControl() + ")";
    }

    public static class Pom {
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version + this.getClassifier(":");
        }

        private String getClassifier(String joiner) {
            return StringUtils.isEmpty((CharSequence)this.classifier) ? "" : joiner + this.classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }
    }

    public static class Dependency {
        private List<Pom> pom = Collections.emptyList();
        private List<String> jar = Collections.emptyList();

        public static Dependency toDependency(String dependency) {
            if (Utils.notEmpty((Object)dependency)) {
                return JacksonUtils.read(dependency, new TypeReference<Dependency>(){});
            }
            return new Dependency();
        }

        public boolean isEmpty() {
            return this.pom.isEmpty() && this.jar.isEmpty();
        }

        public boolean eq(Dependency other) {
            if (other == null) {
                return false;
            }
            if (this.isEmpty() && other.isEmpty()) {
                return true;
            }
            if (this.pom.size() != other.pom.size() || this.jar.size() != other.jar.size()) {
                return false;
            }
            File localJar = WebUtils.getAppTempDir();
            File localUploads = new File(Workspace.local().APP_UPLOADS());
            HashSet<String> otherJars = new HashSet<String>(other.jar);
            for (String jarName : this.jar) {
                if (otherJars.contains(jarName) && FileUtils.equals((File)new File(localJar, jarName), (File)new File(localUploads, jarName))) continue;
                return false;
            }
            return new HashSet<Pom>(this.pom).containsAll(other.pom);
        }

        public DependencyInfo toJarPackDeps() {
            List mvnArts = this.pom.stream().map(pom -> new Artifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getClassifier())).collect(Collectors.toList());
            List extJars = this.jar.stream().map(jar -> Workspace.local().APP_UPLOADS() + "/" + jar).collect(Collectors.toList());
            return new DependencyInfo(mvnArts, extJars);
        }

        public List<Pom> getPom() {
            return this.pom;
        }

        public List<String> getJar() {
            return this.jar;
        }

        public void setPom(List<Pom> pom) {
            this.pom = pom;
        }

        public void setJar(List<String> jar) {
            this.jar = jar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Pom> this$pom = this.getPom();
            List<Pom> other$pom = other.getPom();
            if (this$pom == null ? other$pom != null : !((Object)this$pom).equals(other$pom)) {
                return false;
            }
            List<String> this$jar = this.getJar();
            List<String> other$jar = other.getJar();
            return !(this$jar == null ? other$jar != null : !((Object)this$jar).equals(other$jar));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Pom> $pom = this.getPom();
            result = result * 59 + ($pom == null ? 43 : ((Object)$pom).hashCode());
            List<String> $jar = this.getJar();
            result = result * 59 + ($jar == null ? 43 : ((Object)$jar).hashCode());
            return result;
        }

        public String toString() {
            return "Application.Dependency(pom=" + this.getPom() + ", jar=" + this.getJar() + ")";
        }
    }
}

