/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.MetricWatcherConfig;
import org.apache.streampark.flink.kubernetes.event.FlinkJobCheckpointChangeEvent;
import org.apache.streampark.flink.kubernetes.model.CheckpointCV;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.Checkpoint;
import org.apache.streampark.flink.kubernetes.watcher.Checkpoint$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkCheckpointWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\r\u001b\u0001\u001dB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011)\u0019!C\u0002\u0001\"AA\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0015\r\u0011b\u0001G\u0011!Q\u0005A!A!\u0002\u00139\u0005\"B&\u0001\t\u0003a\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007;\u0002\u0001\u000b\u0011\u0002+\t\u000fy\u0003!\u0019!C\u0006?\"1Q\r\u0001Q\u0001\n\u0001DqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\nY\u0002\u0001\r\u00111A\u0005\n5D\u0011B \u0001A\u0002\u0003\u0007I\u0011B@\t\u0013Y\u0004\u0001\u0019!A!B\u0013q\u0007bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003/\u0001A\u0011IA\u000b\u0011\u001d\tI\u0002\u0001C!\u0003+Aq!a\u0007\u0001\t\u0003\n)\u0002C\u0004\u0002\u001e\u0001!\t!a\b\b\u0013\u0005E#$!A\t\u0002\u0005Mc\u0001C\r\u001b\u0003\u0003E\t!!\u0016\t\r-3B\u0011AA,\u0011%\tIFFI\u0001\n\u0003\tYF\u0001\fGY&t7n\u00115fG.\u0004x.\u001b8u/\u0006$8\r[3s\u0015\tYB$A\u0004xCR\u001c\u0007.\u001a:\u000b\u0005uq\u0012AC6vE\u0016\u0014h.\u001a;fg*\u0011q\u0004I\u0001\u0006M2Lgn\u001b\u0006\u0003C\t\n!b\u001d;sK\u0006l\u0007/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000b\u00187!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGN\u0003\u00024A\u000511m\\7n_:L!!\u000e\u0019\u0003\r1{wmZ3s!\t9\u0004(D\u0001\u001b\u0013\tI$D\u0001\u0007GY&t7nV1uG\",'/\u0001\u0003d_:4\u0007C\u0001\u001f>\u001b\u0005a\u0012B\u0001 \u001d\u0005MiU\r\u001e:jG^\u000bGo\u00195fe\u000e{gNZ5h\u0003=9\u0018\r^2i\u0007>tGO]8mY\u0016\u0014X#A!\u0011\u0005q\u0012\u0015BA\"\u001d\u0005]1E.\u001b8l\u0017b\u001ax+\u0019;dQ\u000e{g\u000e\u001e:pY2,'/\u0001\txCR\u001c\u0007nQ8oiJ|G\u000e\\3sA\u0005AQM^3oi\n+8/F\u0001H!\ta\u0004*\u0003\u0002J9\tq1\t[1oO\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}Q\u0011Q*\u0015\u000b\u0004\u001d>\u0003\u0006CA\u001c\u0001\u0011\u0015yd\u0001q\u0001B\u0011\u0015)e\u0001q\u0001H\u0011\u001dQd\u0001%AA\u0002m\n\u0011\u0003\u001e:bG.$\u0016m]6Fq\u0016\u001c\u0007k\\8m+\u0005!\u0006CA+\\\u001b\u00051&BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003ceS\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]-\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\nue\u0006\u001c7\u000eV1tW\u0016CXm\u0019)p_2\u0004\u0013!\u0005;sC\u000e\\G+Y:l\u000bb,7-\u001e;peV\t\u0001\r\u0005\u0002bG6\t!M\u0003\u0002XU%\u0011AM\u0019\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0005;sC\u000e\\G+Y:l\u000bb,7-\u001e;pe\u0002\n\u0011\u0002^5nKJ,\u00050Z2\u0016\u0003!\u0004\"!V5\n\u0005)4&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006QA/[7fe\u0016CXm\u0019\u0011\u0002\u001bQLW.\u001a:TG\",G-\u001e7f+\u0005q\u0007GA8u!\r)\u0006O]\u0005\u0003cZ\u0013qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0003gRd\u0001\u0001B\u0005v\u001f\u0005\u0005\t\u0011!B\u0001o\n\u0019q\fJ\u0019\u0002\u001dQLW.\u001a:TG\",G-\u001e7fAE\u0011\u0001p\u001f\t\u0003SeL!A\u001f\u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0006`\u0005\u0003{*\u00121!\u00118z\u0003E!\u0018.\\3s'\u000eDW\rZ;mK~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0001E\u0002*\u0003\u0007I1!!\u0002+\u0005\u0011)f.\u001b;\t\u0013\u0005%a\"!AA\u0002\u0005-\u0011a\u0001=%cA\"\u0011QBA\t!\u0011)\u0006/a\u0004\u0011\u0007M\f\t\u0002\u0002\u0006v\u0003\u000f\t\t\u0011!A\u0003\u0002]\fq\u0001Z8Ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0002\u00051Am\\*u_B\fq\u0001Z8DY>\u001cX-A\u0004e_^\u000bGo\u00195\u0002\u000f\r|G\u000e\\3diR!\u0011\u0011EA\u001a!\u0015I\u00131EA\u0014\u0013\r\t)C\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\u001d\u0003\u0015iw\u000eZ3m\u0013\u0011\t\t$a\u000b\u0003\u0019\rCWmY6q_&tGo\u0011,\t\u000f\u0005UB\u00031\u0001\u00028\u00059AO]1dW&#\u0007\u0003BA\u0015\u0003sIA!a\u000f\u0002,\t9AK]1dW&#\u0007f\u0001\u0001\u0002@A!\u0011\u0011IA'\u001b\t\t\u0019EC\u0002X\u0003\u000bRA!a\u0012\u0002J\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005-\u0013!\u00026bm\u0006D\u0018\u0002BA(\u0003\u0007\u0012!\u0002\u00165sK\u0006$7+\u00194f\u0003Y1E.\u001b8l\u0007\",7m\u001b9pS:$x+\u0019;dQ\u0016\u0014\bCA\u001c\u0017'\t1\u0002\u0006\u0006\u0002\u0002T\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!\u0018+\u0007m\nyf\u000b\u0002\u0002bA!\u00111MA6\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\r\t9EK\u0005\u0005\u0003[\n)GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
@ThreadSafe
public class FlinkCheckpointWatcher
implements Logger,
FlinkWatcher {
    private final MetricWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutorService trackTaskExecPool;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private final ScheduledExecutorService timerExec;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static MetricWatcherConfig $lessinit$greater$default$1() {
        return FlinkCheckpointWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutorService trackTaskExecPool() {
        return this.trackTaskExecPool;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledExecutorService timerExec() {
        return this.timerExec;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.timerExec().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher started.");
    }

    @Override
    public void doStop() {
        this.timerSchedule().cancel(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher stopped.");
    }

    @Override
    public void doClose() {
        this.timerExec().shutdownNow();
        this.trackTaskExecutor().shutdownNow();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getActiveWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set futures = (Set)trackIds.map((Function1 & Serializable & scala.Serializable)id -> {
                void var2_2;
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.collect((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                future.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> {
                    FlinkCheckpointWatcher.$anonfun$doWatch$6(this, id, x$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)this.trackTaskExecutor());
                return var2_2;
            }, Set$.MODULE$.canBuildFrom());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("[FlinkCheckpointWatcher] tracking flink-job checkpoint on kubernetes mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(21).append(" trackingClusterKeys=").append(trackIds$1.mkString(",")).toString()).toString());
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<CheckpointCV> collect(TrackId trackId) {
        None$ none$;
        Object object = new Object();
        try {
            if (trackId.jobId() != null) {
                String flinkJmRestUrl = (String)this.watchController().getClusterRestUrl(ClusterKey$.MODULE$.of(trackId)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkCheckpointWatcher.$anonfun$collect$1(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                Checkpoint checkpoint = (Checkpoint)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Checkpoint c;
                    Option<Checkpoint> option = Checkpoint$.MODULE$.as(Request.get((String)new StringBuilder(18).append(flinkJmRestUrl).append("/jobs/").append(trackId.jobId()).append("/checkpoints").toString()).connectTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC())).responseTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC())).execute().returnContent().asString(StandardCharsets.UTF_8));
                    if (!(option instanceof Some)) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    Some some = (Some)option;
                    Checkpoint checkpoint = c = (Checkpoint)some.value();
                    return checkpoint;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                long x$1 = checkpoint.id();
                String x$2 = checkpoint.externalPath();
                boolean x$3 = checkpoint.isSavepoint();
                String x$42 = checkpoint.checkpointType();
                String x$5 = checkpoint.status();
                long x$6 = checkpoint.triggerTimestamp();
                CheckpointCV checkpointCV = new CheckpointCV(x$1, x$5, x$2, x$3, x$42, x$6);
                none$ = new Some((Object)checkpointCV);
            } else {
                none$ = None$.MODULE$;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$doWatch$6(FlinkCheckpointWatcher $this, TrackId id$1, Try x$2) {
        Option option = (Option)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            CheckpointCV cp = (CheckpointCV)some.value();
            $this.eventBus().postAsync(new FlinkJobCheckpointChangeEvent(id$1, cp));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$collect$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public FlinkCheckpointWatcher(MetricWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        Logger.$init$((Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecPool = Executors.newWorkStealingPool();
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService(this.trackTaskExecPool());
        this.timerExec = Executors.newSingleThreadScheduledExecutor();
    }
}

