/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.TopologyDetails;

public class Topologies
implements Iterable<TopologyDetails> {
    Map<String, TopologyDetails> topologies;
    Map<String, String> nameToId;
    Map<String, Map<String, Component>> allComponents;

    public Topologies(TopologyDetails ... details) {
        this(Topologies.mkMap(details));
    }

    public Topologies(Map<String, TopologyDetails> topologies) {
        if (topologies == null) {
            topologies = Collections.emptyMap();
        }
        this.topologies = new HashMap<String, TopologyDetails>(topologies);
        this.nameToId = new HashMap<String, String>(topologies.size());
        for (Map.Entry<String, TopologyDetails> entry : topologies.entrySet()) {
            TopologyDetails topology = entry.getValue();
            this.nameToId.put(topology.getName(), entry.getKey());
        }
    }

    public Topologies(Topologies src) {
        this(src.topologies);
    }

    private static Map<String, TopologyDetails> mkMap(TopologyDetails[] details) {
        HashMap<String, TopologyDetails> ret = new HashMap<String, TopologyDetails>();
        for (TopologyDetails td : details) {
            if (ret.put(td.getId(), td) == null) continue;
            throw new IllegalArgumentException("Cannot have multiple topologies with the id " + td.getId());
        }
        return ret;
    }

    public Collection<String> getAllIds() {
        return this.topologies.keySet();
    }

    public TopologyDetails getById(String topologyId) {
        return this.topologies.get(topologyId);
    }

    public TopologyDetails getByName(String topologyName) {
        String topologyId = this.nameToId.get(topologyName);
        if (topologyId == null) {
            return null;
        }
        return this.getById(topologyId);
    }

    public Collection<TopologyDetails> getTopologies() {
        return this.topologies.values();
    }

    public Collection<TopologyDetails> getTopologiesOwnedBy(String user) {
        HashSet<TopologyDetails> ret = new HashSet<TopologyDetails>();
        for (TopologyDetails td : this) {
            if (!user.equals(td.getTopologySubmitter())) continue;
            ret.add(td);
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Topologies:\n");
        for (TopologyDetails td : this.getTopologies()) {
            ret.append(td.toString()).append("\n");
        }
        return ret.toString();
    }

    @Override
    public Iterator<TopologyDetails> iterator() {
        return this.topologies.values().iterator();
    }
}

