/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import io.dropwizard.jetty.ZipExceptionHandlingRequestWrapper;
import io.dropwizard.util.Throwables;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.EOFException;
import java.io.IOException;
import java.util.Optional;
import java.util.zip.ZipException;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.server.Request;

public class ZipExceptionHandlingServletFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            Optional throwable = Throwables.findThrowableInChain(t -> t.getCause() == null && (t instanceof ZipException || t instanceof EOFException), (Throwable)e);
            if (throwable.isPresent() && request instanceof ServletApiRequest) {
                ServletApiRequest servletApiRequest = (ServletApiRequest)request;
                this.handleGzipExceptionIfNecessary(servletApiRequest);
            }
            throw e;
        }
    }

    private void handleGzipExceptionIfNecessary(ServletApiRequest servletApiRequest) {
        Request currentRequest = servletApiRequest.getRequest();
        ZipExceptionHandlingRequestWrapper unwrapped = (ZipExceptionHandlingRequestWrapper)((Object)Request.as((Request)currentRequest, ZipExceptionHandlingRequestWrapper.class));
        if (unwrapped == null || unwrapped.getGzipException() == null) {
            return;
        }
        Throwable gzipException = unwrapped.getGzipException();
        throw new BadMessageException(400, gzipException.getMessage(), gzipException);
    }
}

