/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaLengthByteArrayReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataTypes;

public class VectorizedDeltaByteArrayReader
extends VectorizedReaderBase
implements VectorizedValuesReader,
RequiresPreviousReader {
    private final VectorizedDeltaBinaryPackedReader prefixLengthReader = new VectorizedDeltaBinaryPackedReader();
    private final VectorizedDeltaLengthByteArrayReader suffixReader = new VectorizedDeltaLengthByteArrayReader();
    private WritableColumnVector prefixLengthVector;
    private ByteBuffer previous;
    private int currentRow = 0;
    private final WritableColumnVector binaryValVector = new OnHeapColumnVector(1, DataTypes.BinaryType);
    private final WritableColumnVector tempBinaryValVector = new OnHeapColumnVector(1, DataTypes.BinaryType);

    VectorizedDeltaByteArrayReader() {
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.prefixLengthVector = new OnHeapColumnVector(valueCount, DataTypes.IntegerType);
        this.prefixLengthReader.initFromPage(valueCount, in);
        this.prefixLengthReader.readIntegers(this.prefixLengthReader.getTotalValueCount(), this.prefixLengthVector, 0);
        this.suffixReader.initFromPage(valueCount, in);
    }

    @Override
    public Binary readBinary(int len) {
        this.readValues(1, this.binaryValVector, 0);
        return Binary.fromConstantByteArray((byte[])this.binaryValVector.getBinary(0));
    }

    private void readValues(int total, WritableColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            int prefixLength = this.prefixLengthVector.getInt(this.currentRow);
            ByteBuffer suffix = this.suffixReader.getBytes(this.currentRow);
            byte[] suffixArray = suffix.array();
            int suffixLength = suffix.limit() - suffix.position();
            int length = prefixLength + suffixLength;
            WritableColumnVector arrayData = c.arrayData();
            int offset = arrayData.getElementsAppended();
            if (prefixLength != 0) {
                arrayData.appendBytes(prefixLength, this.previous.array(), this.previous.position());
            }
            arrayData.appendBytes(suffixLength, suffixArray, suffix.position());
            c.putArray(rowId + i, offset, length);
            this.previous = arrayData.getByteBuffer(offset, length);
            ++this.currentRow;
        }
    }

    @Override
    public void readBinary(int total, WritableColumnVector c, int rowId) {
        this.readValues(total, c, rowId);
    }

    public void setPreviousReader(ValuesReader reader) {
        if (reader != null) {
            this.previous = ((VectorizedDeltaByteArrayReader)reader).previous;
        }
    }

    @Override
    public void skipBinary(int total) {
        WritableColumnVector c1 = this.tempBinaryValVector;
        WritableColumnVector c2 = this.binaryValVector;
        for (int i = 0; i < total; ++i) {
            int prefixLength = this.prefixLengthVector.getInt(this.currentRow);
            ByteBuffer suffix = this.suffixReader.getBytes(this.currentRow);
            byte[] suffixArray = suffix.array();
            int suffixLength = suffix.limit() - suffix.position();
            int length = prefixLength + suffixLength;
            WritableColumnVector arrayData = c1.arrayData();
            c1.reset();
            if (prefixLength != 0) {
                arrayData.appendBytes(prefixLength, this.previous.array(), this.previous.position());
            }
            arrayData.appendBytes(suffixLength, suffixArray, suffix.position());
            this.previous = arrayData.getByteBuffer(0, length);
            ++this.currentRow;
            WritableColumnVector tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
    }
}

