/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.ResolvedIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.RemoveShuffleFiles$;
import org.apache.spark.sql.execution.command.PathFilterIgnoreNonData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2CatalogAndIdentifier$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.util.collection.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class CommandUtils$
implements Logging {
    public static final CommandUtils$ MODULE$ = new CommandUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void updateTableStats(SparkSession sparkSession, CatalogTable table) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (sparkSession.sessionState().conf().autoSizeUpdateEnabled()) {
            CatalogTable newTable = catalog.getTableMetadata(table.identifier());
            Tuple2<BigInt, Seq<CatalogTablePartition>> tuple2 = this.calculateTotalSize(sparkSession, newTable, this.calculateTotalSize$default$3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BigInt newSize = (BigInt)tuple2._1();
            Seq newPartitions = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newSize, (Object)newPartitions);
            BigInt newSize2 = (BigInt)tuple22._1();
            Seq newPartitions2 = (Seq)tuple22._2();
            boolean isNewStats = BoxesRunTime.unboxToBoolean((Object)newTable.stats().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CommandUtils$.$anonfun$updateTableStats$1(newSize2, x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            if (isNewStats) {
                CatalogStatistics newStats = new CatalogStatistics(newSize2, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
            }
            if (newPartitions2.nonEmpty()) {
                catalog.alterPartitions(table.identifier(), newPartitions2);
                return;
            }
            return;
        }
        if (table.stats().nonEmpty()) {
            catalog.alterTableStats(table.identifier(), (Option)None$.MODULE$);
            return;
        }
        catalog.refreshTable(table.identifier());
    }

    public Tuple2<BigInt, Seq<CatalogTablePartition>> calculateTotalSize(SparkSession spark, CatalogTable catalogTable, Option<scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt>> partitionRowCount) {
        Tuple2<BigInt, Seq<CatalogTablePartition>> tuple2;
        SessionState sessionState = spark.sessionState();
        long startTime = System.nanoTime();
        if (catalogTable.partitionColumnNames().isEmpty()) {
            long size = this.calculateSingleLocationSize(sessionState, catalogTable.identifier(), (Option<URI>)catalogTable.storage().locationUri());
            v0 = new Tuple2<BigInt, Seq<CatalogTablePartition>>((Object)package$.MODULE$.BigInt().apply(size), (Object)Nil$.MODULE$);
        } else {
            Seq partitions = sessionState.catalog().listPartitions(catalogTable.identifier(), sessionState.catalog().listPartitions$default$2());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting to calculate sizes for ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)partitions.length()))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitions."}))).log((Seq)Nil$.MODULE$))));
            v0 = tuple2 = this.calculatePartitionStats(spark, catalogTable, (Seq<CatalogTablePartition>)partitions, partitionRowCount);
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigInt totalSize = (BigInt)tuple2._1();
        Seq newPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)totalSize, (Object)newPartitions);
        BigInt totalSize2 = (BigInt)tuple22._1();
        Seq newPartitions2 = (Seq)tuple22._2();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"It took ", " ms to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME, BoxesRunTime.boxToLong((long)((System.nanoTime() - startTime) / 1000000L)))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"calculate the total size for table ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TABLE_NAME, catalogTable.identifier())})))));
        return new Tuple2((Object)totalSize2, (Object)newPartitions2);
    }

    public Option<scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt>> calculateTotalSize$default$3() {
        return None$.MODULE$;
    }

    public Tuple2<BigInt, Seq<CatalogTablePartition>> calculatePartitionStats(SparkSession spark, CatalogTable catalogTable, Seq<CatalogTablePartition> partitions, Option<scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt>> partitionRowCount) {
        Seq paths = (Seq)partitions.map((Function1 & Serializable)x$4 -> x$4.storage().locationUri());
        Seq<Object> sizes = this.calculateMultipleLocationSizes(spark, catalogTable.identifier(), (Seq<Option<URI>>)paths);
        Seq newPartitions = (Seq)((IterableOps)partitions.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CatalogTablePartition p = (CatalogTablePartition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                Option newRowCount = partitionRowCount.flatMap((Function1 & Serializable)x$5 -> x$5.get((Object)p.spec()));
                Option<CatalogStatistics> newStats = MODULE$.compareAndGetNewStats((Option<CatalogStatistics>)p.stats(), BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)sizes.apply(idx))), (Option<BigInt>)newRowCount);
                return newStats.map((Function1 & Serializable)x$6 -> {
                    Option x$1 = newStats;
                    scala.collection.immutable.Map x$2 = p.copy$default$1();
                    CatalogStorageFormat x$3 = p.copy$default$2();
                    scala.collection.immutable.Map x$4 = p.copy$default$3();
                    long x$5 = p.copy$default$4();
                    long x$62 = p.copy$default$5();
                    return p.copy(x$2, x$3, x$4, x$5, x$62, x$1);
                });
            }
            throw new MatchError((Object)tuple2);
        });
        return new Tuple2((Object)BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)sizes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), (Object)newPartitions);
    }

    public Option<scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt>> calculatePartitionStats$default$4() {
        return None$.MODULE$;
    }

    public long calculateSingleLocationSize(SessionState sessionState, TableIdentifier identifier, Option<URI> locationUri) {
        String stagingDir = sessionState.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        long startTime = System.nanoTime();
        long size = BoxesRunTime.unboxToLong((Object)locationUri.map((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateSingleLocationSize$2(sessionState, identifier, stagingDir, p))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "It took " + durationInMs + " ms to calculate the total file size under path " + locationUri + ".");
        return size;
    }

    public Seq<Object> calculateMultipleLocationSizes(SparkSession sparkSession, TableIdentifier tid, Seq<Option<URI>> paths) {
        if (sparkSession.sessionState().conf().parallelFileListingInStatsComputation()) {
            return this.calculateMultipleLocationSizesInParallel(sparkSession, (Seq<Option<Path>>)((Seq)paths.map((Function1 & Serializable)x$7 -> x$7.map((Function1 & Serializable)x$8 -> new Path(x$8)))));
        }
        return (Seq)paths.map((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.MODULE$.calculateSingleLocationSize(sparkSession.sessionState(), tid, (Option<URI>)p)));
    }

    public Seq<Object> calculateMultipleLocationSizesInParallel(SparkSession sparkSession, Seq<Option<Path>> paths) {
        String stagingDir = sparkSession.sessionState().conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        PathFilterIgnoreNonData filter = new PathFilterIgnoreNonData(stagingDir);
        Seq sizes = (Seq)InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)((Seq)paths.flatten(Predef$.MODULE$.$conforms())), sparkSession.sessionState().newHadoopConf(), filter, sparkSession, InMemoryFileIndex$.MODULE$.bulkListLeafFiles$default$5()).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$1(x0$1)));
        return (Seq)((IterableOps)paths.zipWithIndex()).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$3(sizes, x0$2)));
    }

    public Option<CatalogStatistics> compareAndGetNewStats(Option<CatalogStatistics> oldStats, BigInt newTotalSize, Option<BigInt> newRowCount) {
        None$ newStats;
        block2: {
            BigInt oldTotalSize = (BigInt)oldStats.map((Function1 & Serializable)x$11 -> x$11.sizeInBytes()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            BigInt oldRowCount = (BigInt)oldStats.flatMap((Function1 & Serializable)x$12 -> x$12.rowCount()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            newStats = None$.MODULE$;
            if (newTotalSize.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0))) {
                BigInt bigInt = newTotalSize;
                BigInt bigInt2 = oldTotalSize;
                if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
                    newStats = new Some((Object)new CatalogStatistics(newTotalSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
                }
            }
            if (!newRowCount.isDefined() || !((Ordered)newRowCount.get()).$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)) || BoxesRunTime.equals((Object)newRowCount.get(), (Object)oldRowCount)) break block2;
            newStats = newStats.isDefined() ? newStats.map((Function1 & Serializable)x$13 -> {
                Option x$1 = newRowCount;
                BigInt x$2 = x$13.copy$default$1();
                scala.collection.immutable.Map x$3 = x$13.copy$default$3();
                return x$13.copy(x$2, x$1, x$3);
            }) : new Some((Object)new CatalogStatistics(oldTotalSize, newRowCount, CatalogStatistics$.MODULE$.apply$default$3()));
        }
        return newStats;
    }

    public void analyzeTable(SparkSession sparkSession, TableIdentifier tableIdent, boolean noScan) {
        SessionState sessionState = sparkSession.sessionState();
        boolean partitionStatsEnabled = sessionState.conf().updatePartStatsInAnalyzeTableEnabled();
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable)() -> sessionState.catalog().getCurrentDatabase());
        TableIdentifier tableIdentWithDB = TableIdentifier$.MODULE$.apply(tableIdent.table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            Dataset table = sparkSession.table(tableIdent.quotedString());
            CacheManager cacheManager = sparkSession.sharedState().cacheManager();
            if (cacheManager.lookupCachedData((org.apache.spark.sql.classic.Dataset<?>)table).isDefined()) {
                if (!noScan) {
                    table.count();
                    return;
                }
                return;
            }
            throw QueryCompilationErrors$.MODULE$.analyzeTableNotSupportedOnViewsError();
        }
        scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt> rowCounts = noScan || !partitionStatsEnabled ? Predef$.MODULE$.Map().empty() : this.calculateRowCountsPerPartition(sparkSession, tableMeta, (Option<scala.collection.immutable.Map<String, String>>)None$.MODULE$);
        Tuple2<BigInt, Seq<CatalogTablePartition>> tuple2 = this.calculateTotalSize(sparkSession, tableMeta, (Option<scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt>>)new Some(rowCounts));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigInt newTotalSize = (BigInt)tuple2._1();
        Seq newPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newTotalSize, (Object)newPartitions);
        BigInt newTotalSize2 = (BigInt)tuple22._1();
        Seq newPartitions2 = (Seq)tuple22._2();
        None$ newRowCount = noScan ? None$.MODULE$ : new Some((Object)package$.MODULE$.BigInt().apply(sparkSession.table(tableIdentWithDB).count()));
        Option<CatalogStatistics> newStats = this.compareAndGetNewStats((Option<CatalogStatistics>)tableMeta.stats(), newTotalSize2, (Option<BigInt>)newRowCount);
        if (newStats.isDefined()) {
            sessionState.catalog().alterTableStats(tableIdentWithDB, newStats);
        }
        if (newPartitions2.nonEmpty() && partitionStatsEnabled) {
            sessionState.catalog().alterPartitions(tableIdentWithDB, newPartitions2);
            return;
        }
    }

    public Tuple2<Object, scala.collection.immutable.Map<Attribute, ColumnStat>> computeColumnStats(SparkSession sparkSession, LogicalPlan relation, Seq<Attribute> columns) {
        SQLConf conf = sparkSession.sessionState().conf();
        AttributeMap<ArrayData> attributePercentiles = this.computePercentiles(columns, sparkSession, relation);
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqOps)columns.map((Function1 & Serializable)x$15 -> MODULE$.statExprs((Attribute)x$15, conf, attributePercentiles))).$plus$colon((Object)aggregateExpression);
        Seq namedExpressions = (Seq)expressions.map((Function1 & Serializable)e -> {
            Expression x$1 = e;
            String x$2 = e.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        });
        SparkSession x$7 = sparkSession;
        Aggregate x$8 = new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation, Aggregate$.MODULE$.apply$default$4());
        RemoveShuffleFiles$ x$9 = RemoveShuffleFiles$.MODULE$;
        QueryPlanningTracker x$10 = QueryExecution$.MODULE$.$lessinit$greater$default$3();
        Enumeration.Value x$11 = QueryExecution$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = QueryExecution$.MODULE$.$lessinit$greater$default$6();
        UUID x$13 = QueryExecution$.MODULE$.$lessinit$greater$default$7();
        InternalRow statsRow = (InternalRow)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(x$7, (LogicalPlan)x$8, x$10, x$11, x$9, x$12, x$13).executedPlan().executeTake(1)));
        long rowCount = statsRow.getLong(0);
        scala.collection.immutable.Map columnStats = ((IterableOnceOps)((IterableOps)columns.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new Tuple2((Object)attr, (Object)MODULE$.rowToColumnStat(statsRow.getStruct(i + 1, 7), attr, rowCount, (Option<ArrayData>)attributePercentiles.get(attr)));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    private AttributeMap<ArrayData> computePercentiles(Seq<Attribute> attributesToAnalyze, SparkSession sparkSession, LogicalPlan relation) {
        HashMap attributePercentiles;
        block0: {
            SQLConf conf = sparkSession.sessionState().conf();
            Nil$ attrsToGenHistogram = conf.histogramEnabled() ? (Seq)attributesToAnalyze.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CommandUtils$.MODULE$.supportsHistogram(a.dataType()))) : Nil$.MODULE$;
            attributePercentiles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (!attrsToGenHistogram.nonEmpty()) break block0;
            Object[] percentiles = (Object[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), conf.histogramNumBins()).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> (double)i / (double)conf.histogramNumBins()).toArray(ClassTag$.MODULE$.Any());
            Seq namedExprs = (Seq)attrsToGenHistogram.map((Function1 & Serializable)attr -> {
                AggregateExpression expr;
                ApproximatePercentile aggFunc = new ApproximatePercentile((Expression)attr, (Expression)new Literal((Object)new GenericArrayData(percentiles), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)conf.percentileAccuracy())));
                AggregateExpression x$1 = expr = aggFunc.toAggregateExpression();
                String x$2 = expr.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
            });
            SparkSession x$7 = sparkSession;
            Aggregate x$8 = new Aggregate((Seq)Nil$.MODULE$, namedExprs, relation, Aggregate$.MODULE$.apply$default$4());
            RemoveShuffleFiles$ x$9 = RemoveShuffleFiles$.MODULE$;
            QueryPlanningTracker x$10 = QueryExecution$.MODULE$.$lessinit$greater$default$3();
            Enumeration.Value x$11 = QueryExecution$.MODULE$.$lessinit$greater$default$4();
            boolean x$12 = QueryExecution$.MODULE$.$lessinit$greater$default$6();
            UUID x$13 = QueryExecution$.MODULE$.$lessinit$greater$default$7();
            InternalRow percentilesRow = (InternalRow)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(x$7, (LogicalPlan)x$8, x$10, x$11, x$9, x$12, x$13).executedPlan().executeTake(1)));
            ((IterableOnceOps)attrsToGenHistogram.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Attribute attr = (Attribute)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ArrayData percentiles = percentilesRow.getArray(i);
                    if (percentiles != null) {
                        return attributePercentiles.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)percentiles));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return AttributeMap$.MODULE$.apply((Iterable)attributePercentiles);
    }

    private boolean supportsHistogram(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof IntegralType) {
            return true;
        }
        if (dataType2 instanceof DecimalType) {
            return true;
        }
        if (DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) {
            return true;
        }
        return dataType2 instanceof DatetimeType;
    }

    private CreateNamedStruct statExprs(Attribute col, SQLConf conf, AttributeMap<ArrayData> colPercentiles) {
        Literal one = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)LongType$.MODULE$);
        Count numNonNulls = col.nullable() ? Count$.MODULE$.apply((Expression)col) : Count$.MODULE$.apply((Expression)one);
        Least ndv = new Least((Seq)new .colon.colon((Object)new HyperLogLogPlusPlus((Expression)col, conf.ndvMaxError(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)numNonNulls, (List)Nil$.MODULE$)));
        Subtract numNulls = new Subtract((Expression)Count$.MODULE$.apply((Expression)one), (Expression)numNonNulls, Subtract$.MODULE$.apply$default$3());
        Literal defaultSize = new Literal((Object)BoxesRunTime.boxToLong((long)col.dataType().defaultSize()), (DataType)LongType$.MODULE$);
        Literal nullArray = new Literal(null, (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
        DataType dataType = col.dataType();
        if (dataType instanceof IntegralType) {
            return this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        }
        if (dataType instanceof DecimalType) {
            return this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        }
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        }
        if (dataType instanceof DatetimeType) {
            return this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        }
        if (BinaryType$.MODULE$.equals(dataType) ? true : dataType instanceof StringType) {
            Literal nullLit = new Literal(null, col.dataType());
            return CommandUtils$.struct$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv, nullLit, nullLit, numNulls, new Coalesce((Seq)new .colon.colon((Object)new Ceil((Expression)new Average((Expression)new Length((Expression)col), Average$.MODULE$.apply$default$2())), (List)new .colon.colon((Object)defaultSize, (List)Nil$.MODULE$))), new Coalesce((Seq)new .colon.colon((Object)new Cast((Expression)new Max((Expression)new Length((Expression)col)), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)defaultSize, (List)Nil$.MODULE$))), nullArray}));
        }
        throw QueryCompilationErrors$.MODULE$.analyzingColumnStatisticsNotSupportedForColumnTypeError(col.name(), col.dataType());
    }

    private ColumnStat rowToColumnStat(InternalRow row, Attribute attr, long rowCount, Option<ArrayData> percentiles) {
        ColumnStat cs = new ColumnStat(Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(0))), Option$.MODULE$.apply(row.get(1, attr.dataType())), Option$.MODULE$.apply(row.get(2, attr.dataType())), Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(3))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(4))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(5))), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
        if (row.isNullAt(6) || cs.nullCount().isEmpty()) {
            return cs;
        }
        long[] ndvs = row.getArray(6).toLongArray();
        Predef$.MODULE$.assert(((ArrayData)percentiles.get()).numElements() == ndvs.length + 1);
        double[] endpoints = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(((ArrayData)percentiles.get()).toArray(attr.dataType(), ClassTag$.MODULE$.Any())), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$16.toString()))), (ClassTag)ClassTag$.MODULE$.Double());
        HistogramBin[] bins = (HistogramBin[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.longArrayOps(ndvs))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long ndv = tuple2._1$mcJ$sp();
                int i = tuple2._2$mcI$sp();
                return new HistogramBin(endpoints[i], endpoints[i + 1], ndv);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(HistogramBin.class));
        BigInt nonNullRows = BigInt$.MODULE$.long2bigInt(rowCount).$minus((BigInt)cs.nullCount().get());
        Histogram histogram = new Histogram(nonNullRows.toDouble() / (double)ndvs.length, bins);
        Some x$1 = new Some((Object)histogram);
        Option x$2 = cs.copy$default$1();
        Option x$3 = cs.copy$default$2();
        Option x$4 = cs.copy$default$3();
        Option x$5 = cs.copy$default$4();
        Option x$6 = cs.copy$default$5();
        Option x$7 = cs.copy$default$6();
        int x$8 = cs.copy$default$8();
        return cs.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option)x$1, x$8);
    }

    private boolean isDataPath(Path path, String stagingDir) {
        return !path.getName().startsWith(stagingDir) && DataSourceUtils$.MODULE$.isDataPath(path);
    }

    public void uncacheTableOrView(SparkSession sparkSession, ResolvedIdentifier ident) {
        Seq nameParts = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident.identifier()).toQualifiedNameParts(ident.catalog());
        this.uncacheTableOrView(sparkSession, (Seq<String>)nameParts, true);
    }

    public void uncacheTableOrView(SparkSession sparkSession, TableIdentifier ident) {
        this.uncacheTableOrView(sparkSession, (Seq<String>)ident.nameParts(), true);
    }

    public void uncacheTableOrView(SparkSession sparkSession, LogicalPlan relation, boolean cascade) {
        DataSourceV2Relation dataSourceV2Relation;
        Option option;
        LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(relation);
        if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty()) {
            TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
            Identifier ident = (Identifier)((Tuple2)option.get())._2();
            if (dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                Seq nameParts = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).toQualifiedNameParts((CatalogPlugin)catalog);
                this.uncacheTableOrView(sparkSession, (Seq<String>)nameParts, cascade);
                return;
            }
        }
        this.uncacheQuery(sparkSession, relation, cascade);
    }

    private void uncacheTableOrView(SparkSession sparkSession, Seq<String> name, boolean cascade) {
        sparkSession.sharedState().cacheManager().uncacheTableOrView(sparkSession, name, cascade, sparkSession.sharedState().cacheManager().uncacheTableOrView$default$4());
    }

    private void uncacheQuery(SparkSession sparkSession, LogicalPlan plan, boolean cascade) {
        sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession, plan, cascade);
    }

    public void recacheTableOrView(SparkSession sparkSession, LogicalPlan relation) {
        DataSourceV2Relation dataSourceV2Relation;
        Option option;
        LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(relation);
        if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty()) {
            TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
            Identifier ident = (Identifier)((Tuple2)option.get())._2();
            if (dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                Seq nameParts = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).toQualifiedNameParts((CatalogPlugin)catalog);
                sparkSession.sharedState().cacheManager().recacheTableOrView(sparkSession, (Seq<String>)nameParts, sparkSession.sharedState().cacheManager().recacheTableOrView$default$3());
                return;
            }
        }
        sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, relation);
    }

    public scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, BigInt> calculateRowCountsPerPartition(SparkSession sparkSession, CatalogTable tableMeta, Option<scala.collection.immutable.Map<String, String>> partitionValueSpec) {
        Column column;
        if (partitionValueSpec.isDefined()) {
            scala.collection.immutable.Iterable filters = (scala.collection.immutable.Iterable)((IterableOps)partitionValueSpec.get()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String columnName = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return functions$.MODULE$.col(columnName).$eq$eq$eq((Object)functions$.MODULE$.lit((Object)value));
                }
                throw new MatchError((Object)tuple2);
            });
            column = (Column)filters.reduce((Function2 & Serializable)(x$17, x$18) -> x$17.$amp$amp(x$18));
        } else {
            column = functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        Column filter = column;
        org.apache.spark.sql.classic.Dataset<Row> tableDf = sparkSession.table(tableMeta.identifier());
        Seq partitionColumns = (Seq)tableMeta.partitionColumnNames().map((Function1 & Serializable)colName -> functions$.MODULE$.col(colName));
        Dataset df = tableDf.filter(filter).groupBy(partitionColumns).count();
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)r -> {
            IndexedSeq partitionColumnValues = partitionColumns.indices().map((Function1 & Serializable)i -> CommandUtils$.$anonfun$calculateRowCountsPerPartition$5(r, BoxesRunTime.unboxToInt((Object)i)));
            scala.collection.immutable.Map spec = Utils$.MODULE$.toMap((Iterable)tableMeta.partitionColumnNames(), (Iterable)partitionColumnValues);
            BigInt count = package$.MODULE$.BigInt().apply(r.getLong(partitionColumns.size()));
            return new Tuple2((Object)spec, (Object)count);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$updateTableStats$1(BigInt newSize$1, CatalogStatistics x$2) {
        BigInt bigInt = newSize$1;
        BigInt bigInt2 = x$2.sizeInBytes();
        return bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2);
    }

    public static final /* synthetic */ long $anonfun$calculateSingleLocationSize$1(String stagingDir$1, FileSystem fs$1, FileStatus status) {
        if (MODULE$.isDataPath(status.getPath(), stagingDir$1)) {
            return CommandUtils$.getPathSize$1(fs$1, status, stagingDir$1);
        }
        return 0L;
    }

    private static final long getPathSize$1(FileSystem fs, FileStatus fileStatus, String stagingDir$1) {
        long size = fileStatus.isDirectory() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(fileStatus.getPath())), (Function1 & Serializable)status -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateSingleLocationSize$1(stagingDir$1, fs, status)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    public static final /* synthetic */ long $anonfun$calculateSingleLocationSize$2(SessionState sessionState$1, TableIdentifier identifier$1, String stagingDir$1, URI p) {
        long l;
        Path path = new Path(p);
        try {
            FileSystem fs = path.getFileSystem(sessionState$1.newHadoopConf());
            l = CommandUtils$.getPathSize$1(fs, fs.getFileStatus(path), stagingDir$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TABLE_NAME, identifier$1.table())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in the database ", " because of "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.DATABASE_NAME, identifier$1.database())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.ERROR, throwable2.toString())})))), throwable2);
                l = 0L;
            }
            throw throwable;
        }
        return l;
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq files = (Seq)tuple2._2();
            return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)files.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getLen()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$4(Seq sizes$2, int idx$1, Path x$10) {
        return BoxesRunTime.unboxToLong((Object)sizes$2.apply(idx$1));
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$3(Seq sizes$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Option p = (Option)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            return BoxesRunTime.unboxToLong((Object)p.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$4(sizes$2, idx, x$10))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final CreateNamedStruct struct$1(Seq exprs) {
        return CreateStruct$.MODULE$.apply((Seq)exprs.map((Function1 & Serializable)expr -> (Expression)expr.transformUp((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AggregateFunction) {
                    AggregateFunction aggregateFunction = (AggregateFunction)A1;
                    return (B1)aggregateFunction.toAggregateExpression();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof AggregateFunction;
            }
        })));
    }

    private final CreateNamedStruct fixedLenTypeStruct$1(Attribute col$1, AttributeMap colPercentiles$1, SQLConf conf$3, Literal nullArray$1, Least ndv$1, Subtract numNulls$1, Literal defaultSize$1) {
        boolean genHistogram = this.supportsHistogram(col$1.dataType()) && colPercentiles$1.contains(col$1);
        Literal intervalNdvsExpr = genHistogram ? new ApproxCountDistinctForIntervals((Expression)col$1, (Expression)new Literal(colPercentiles$1.apply((Object)col$1), (DataType)ArrayType$.MODULE$.apply(col$1.dataType())), conf$3.ndvMaxError(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5()) : nullArray$1;
        return CommandUtils$.struct$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv$1, new Cast((Expression)new Min((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), new Cast((Expression)new Max((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), numNulls$1, defaultSize$1, defaultSize$1, intervalNdvsExpr}));
    }

    public static final /* synthetic */ String $anonfun$calculateRowCountsPerPartition$5(Row r$1, int i) {
        if (r$1.isNullAt(i)) {
            return ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
        }
        return r$1.get(i).toString();
    }

    private CommandUtils$() {
    }
}

