/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.JweHeaderMutator;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.lang.DefaultNestedCollection;
import io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.X509BuilderSupport;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.PublicJwk;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;

public class DefaultJweHeaderMutator<T extends JweHeaderMutator<T>>
extends DelegatingMapMutator<String, Object, ParameterMap, T>
implements JweHeaderMutator<T> {
    protected X509BuilderSupport x509;

    public DefaultJweHeaderMutator() {
        super(new ParameterMap(DefaultJweHeader.PARAMS));
        this.clear();
    }

    public DefaultJweHeaderMutator(DefaultJweHeaderMutator<?> src) {
        super(src.DELEGATE);
        this.x509 = src.x509;
    }

    @Override
    private <F> T put(Parameter<F> param, F value) {
        ((ParameterMap)this.DELEGATE).put(param, value);
        return (T)((JweHeaderMutator)this.self());
    }

    @Override
    public void clear() {
        super.clear();
        this.x509 = new X509BuilderSupport((ParameterMap)this.DELEGATE, IllegalStateException.class);
    }

    public T contentType(String cty) {
        return this.put((Parameter)DefaultHeader.CONTENT_TYPE, (Object)cty);
    }

    public T type(String typ) {
        return this.put((Parameter)DefaultHeader.TYPE, (Object)typ);
    }

    public T setType(String typ) {
        return this.type(typ);
    }

    public T setContentType(String cty) {
        return this.contentType(cty);
    }

    public T setCompressionAlgorithm(String zip) {
        return this.put((Parameter)DefaultHeader.COMPRESSION_ALGORITHM, (Object)zip);
    }

    public NestedCollection<String, T> critical() {
        return new DefaultNestedCollection<String, T>((JweHeaderMutator)this.self(), ((ParameterMap)this.DELEGATE).get(DefaultProtectedHeader.CRIT)){

            @Override
            protected void changed() {
                DefaultJweHeaderMutator.this.put(DefaultProtectedHeader.CRIT, Collections.asSet(this.getCollection()));
            }
        };
    }

    public T jwk(PublicJwk<?> jwk) {
        return this.put((Parameter)DefaultProtectedHeader.JWK, (Object)jwk);
    }

    public T jwkSetUrl(URI uri) {
        return this.put((Parameter)DefaultProtectedHeader.JKU, (Object)uri);
    }

    public T keyId(String kid) {
        return this.put((Parameter)DefaultProtectedHeader.KID, (Object)kid);
    }

    public T setKeyId(String kid) {
        return this.keyId(kid);
    }

    public T setAlgorithm(String alg) {
        return this.put((Parameter)DefaultHeader.ALGORITHM, (Object)alg);
    }

    public T x509Url(URI uri) {
        this.x509.x509Url(uri);
        return (T)((JweHeaderMutator)this.self());
    }

    public T x509Chain(List<X509Certificate> chain) {
        this.x509.x509Chain(chain);
        return (T)((JweHeaderMutator)this.self());
    }

    public T x509Sha1Thumbprint(byte[] thumbprint) {
        this.x509.x509Sha1Thumbprint(thumbprint);
        return (T)((JweHeaderMutator)this.self());
    }

    public T x509Sha256Thumbprint(byte[] thumbprint) {
        this.x509.x509Sha256Thumbprint(thumbprint);
        return (T)((JweHeaderMutator)this.self());
    }

    public T agreementPartyUInfo(byte[] info) {
        return this.put((Parameter)DefaultJweHeader.APU, (Object)info);
    }

    public T agreementPartyUInfo(String info) {
        return this.agreementPartyUInfo(Strings.utf8((CharSequence)Strings.clean((String)info)));
    }

    public T agreementPartyVInfo(byte[] info) {
        return this.put((Parameter)DefaultJweHeader.APV, (Object)info);
    }

    public T agreementPartyVInfo(String info) {
        return this.agreementPartyVInfo(Strings.utf8((CharSequence)Strings.clean((String)info)));
    }

    public T pbes2Count(int count) {
        return this.put((Parameter)DefaultJweHeader.P2C, count);
    }
}

