/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.datanucleus.exceptions.NucleusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RetryingHMSHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingHMSHandler.class);
    private static final String CLASS_NAME = RetryingHMSHandler.class.getName();
    private final IHMSHandler baseHandler;
    private final MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    private final HiveConf origConf;
    private final Configuration activeConf;

    private RetryingHMSHandler(HiveConf hiveConf, IHMSHandler baseHandler, boolean local) throws MetaException {
        this.origConf = hiveConf;
        this.baseHandler = baseHandler;
        if (local) {
            baseHandler.setConf((Configuration)hiveConf);
        }
        this.activeConf = baseHandler.getConf();
        MetaStoreInit.updateConnectionURL(hiveConf, this.getActiveConf(), null, this.metaStoreInitData);
        try {
            this.invoke(baseHandler, baseHandler.getClass().getDeclaredMethod("init", null), null);
        }
        catch (Throwable e) {
            LOG.error("HMSHandler Fatal error: " + ExceptionUtils.getStackTrace((Throwable)e));
            MetaException me = new MetaException(e.getMessage());
            me.initCause(e);
            throw me;
        }
    }

    public static IHMSHandler getProxy(HiveConf hiveConf, IHMSHandler baseHandler, boolean local) throws MetaException {
        RetryingHMSHandler handler = new RetryingHMSHandler(hiveConf, baseHandler, local);
        return (IHMSHandler)Proxy.newProxyInstance(RetryingHMSHandler.class.getClassLoader(), new Class[]{IHMSHandler.class}, (InvocationHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int retryCount = -1;
        int threadId = HiveMetaStore.HMSHandler.get();
        boolean error = true;
        PerfLogger perfLogger = PerfLogger.getPerfLogger((HiveConf)this.origConf, (boolean)false);
        perfLogger.PerfLogBegin(CLASS_NAME, method.getName());
        try {
            Result result = this.invokeInternal(proxy, method, args);
            retryCount = result.numRetries;
            error = false;
            Object object = result.result;
            return object;
        }
        finally {
            StringBuffer additionalInfo = new StringBuffer();
            additionalInfo.append("threadId=").append(threadId).append(" retryCount=").append(retryCount).append(" error=").append(error);
            perfLogger.PerfLogEnd(CLASS_NAME, method.getName(), additionalInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invokeInternal(Object proxy, Method method, Object[] args) throws Throwable {
        boolean gotNewConnectUrl = false;
        boolean reloadConf = HiveConf.getBoolVar((Configuration)this.origConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERFORCERELOADCONF);
        long retryInterval = HiveConf.getTimeVar((Configuration)this.origConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERINTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        int retryLimit = HiveConf.getIntVar((Configuration)this.origConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERATTEMPTS);
        long timeout = HiveConf.getTimeVar((Configuration)this.origConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        Deadline.registerIfNot(timeout);
        if (reloadConf) {
            MetaStoreInit.updateConnectionURL(this.origConf, this.getActiveConf(), null, this.metaStoreInitData);
        }
        int retryCount = 0;
        Throwable caughtException = null;
        while (true) {
            try {
                if (reloadConf || gotNewConnectUrl) {
                    this.baseHandler.setConf(this.getActiveConf());
                }
                Object object = null;
                boolean isStarted = Deadline.startTimer(method.getName());
                try {
                    object = method.invoke((Object)this.baseHandler, args);
                }
                finally {
                    if (isStarted) {
                        Deadline.stopTimer();
                    }
                }
                return new Result(object, retryCount);
            }
            catch (JDOException e) {
                caughtException = e;
            }
            catch (UndeclaredThrowableException e) {
                if (e.getCause() != null) {
                    if (e.getCause() instanceof JDOException) {
                        caughtException = e.getCause();
                    }
                    if (e.getCause() instanceof MetaException && e.getCause().getCause() != null && e.getCause().getCause() instanceof JDOException) {
                        caughtException = e.getCause().getCause();
                    }
                    LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    throw e.getCause();
                }
                LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JDOException) {
                    caughtException = e.getCause();
                }
                if (e.getCause() instanceof NoSuchObjectException || e.getTargetException().getCause() instanceof NoSuchObjectException) {
                    String methodName = method.getName();
                    if (!(methodName.startsWith("get_database") || methodName.startsWith("get_table") || methodName.startsWith("get_partition") || methodName.startsWith("get_function"))) {
                        LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    }
                    throw e.getCause();
                }
                if (e.getCause() instanceof MetaException && e.getCause().getCause() != null) {
                    if (e.getCause().getCause() instanceof JDOException || e.getCause().getCause() instanceof NucleusException) {
                        caughtException = e.getCause().getCause();
                    }
                    if (e.getCause().getCause() instanceof DeadlineException) {
                        Deadline.clear();
                        LOG.error("Error happens in method " + method.getName() + ": " + ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                        throw e.getCause();
                    }
                    LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    throw e.getCause();
                }
                LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                throw e.getCause();
            }
            if (retryCount >= retryLimit) {
                LOG.error("HMSHandler Fatal error: " + ExceptionUtils.getStackTrace((Throwable)caughtException));
                MetaException me = new MetaException(caughtException.getMessage());
                me.initCause(caughtException);
                throw me;
            }
            assert (retryInterval >= 0L);
            LOG.error(String.format("Retrying HMSHandler after %d ms (attempt %d of %d)", retryInterval, ++retryCount, retryLimit) + " with error: " + ExceptionUtils.getStackTrace((Throwable)caughtException));
            Thread.sleep(retryInterval);
            String lastUrl = MetaStoreInit.getConnectionURL(this.getActiveConf());
            gotNewConnectUrl = MetaStoreInit.updateConnectionURL(this.origConf, this.getActiveConf(), lastUrl, this.metaStoreInitData);
        }
    }

    public Configuration getActiveConf() {
        return this.activeConf;
    }

    private static class Result {
        private final Object result;
        private final int numRetries;

        public Result(Object result, int numRetries) {
            this.result = result;
            this.numRetries = numRetries;
        }
    }
}

