/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u0015+\u0001^B\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003A\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B-\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0005\u0004A\u0011A4\t\u000b\u0005\u0004A\u0011A5\t\u000b1\u0004A\u0011I7\t\u000bE\u0004A\u0011\t:\t\u000be\u0004A\u0011\t>\t\r\u0005\r\u0001\u0001\"\u0011Y\u0011\u0019\t)\u0001\u0001C!1\"1\u0011q\u0001\u0001\u0005BaCq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005U\u0003\u0001\"\u0015\u0002X!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003cB\u0011\"a\"\u0001#\u0003%\t!!\u001d\t\u0013\u0005%\u0005!%A\u0005\u0002\u0005E\u0004\"CAF\u0001\u0005\u0005I\u0011IAG\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"!1\u0001\u0003\u0003%\t%a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAwU\u0005\u0005\t\u0012AAx\r!I#&!A\t\u0002\u0005E\bBB1 \t\u0003\u0011I\u0001C\u0005\u0003\f}\t\t\u0011\"\u0012\u0003\u000e!I!qB\u0010\u0002\u0002\u0013\u0005%\u0011\u0003\u0005\n\u00053y\u0012\u0013!C\u0001\u0003cB\u0011Ba\u0007 #\u0003%\t!!\u001d\t\u0013\tuq$!A\u0005\u0002\n}\u0001\"\u0003B\u0019?E\u0005I\u0011AA9\u0011%\u0011\u0019dHI\u0001\n\u0003\t\t\bC\u0005\u00036}\t\t\u0011\"\u0003\u00038\tI1+\u001a8uK:\u001cWm\u001d\u0006\u0003W1\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QFL\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0006M\u0001\u0004gFd'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u000f\u001f@\u000b.\u0003\"!\u000f\u001e\u000e\u0003)J!a\u000f\u0016\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002:{%\u0011aH\u000b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IK\u0001\bG>$WmZ3o\u0013\t!\u0015IA\bD_\u0012,w-\u001a8GC2d'-Y2l!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0014+\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)7\u0003\u0019a$o\\8u}%\t\u0001*\u0003\u0002T\u000f\u00069\u0001/Y2lC\u001e,\u0017BA+W\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019v)A\u0002tiJ,\u0012!\u0017\t\u0003siK!a\u0017\u0016\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013\u0001\u00037b]\u001e,\u0018mZ3\u0002\u00131\fgnZ;bO\u0016\u0004\u0013aB2pk:$(/_\u0001\tG>,h\u000e\u001e:zA\u00051A(\u001b8jiz\"Ba\u00193fMB\u0011\u0011\b\u0001\u0005\u0006/\u001e\u0001\r!\u0017\u0005\b;\u001e\u0001\n\u00111\u0001Z\u0011\u001dyv\u0001%AA\u0002e#\"a\u00195\t\u000b]C\u0001\u0019A-\u0015\u0007\rT7\u000eC\u0003X\u0013\u0001\u0007\u0011\fC\u0003^\u0013\u0001\u0007\u0011,\u0001\u0005ok2d\u0017M\u00197f+\u0005q\u0007C\u0001$p\u0013\t\u0001xIA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m:\nQ\u0001^=qKNL!\u0001_;\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Y\bc\u0001'}}&\u0011QP\u0016\u0002\u0004'\u0016\f\bC\u0001;\u0000\u0013\r\t\t!\u001e\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017\u0001B3wC2$B!!\u0004\u0002\u0014A\u0019a)a\u0004\n\u0007\u0005EqIA\u0002B]fD\u0011\"!\u0006\u0011!\u0003\u0005\r!a\u0006\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005e\u00111D\u0007\u0002Y%\u0019\u0011Q\u0004\u0017\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\rO\u0016$8+\u001a8uK:\u001cWm\u001d\u000b\u0007\u0003G\ty#a\u0011\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b-\u0003\u0011)H/\u001b7\n\t\u00055\u0012q\u0005\u0002\u0011\u000f\u0016tWM]5d\u0003J\u0014\u0018-\u001f#bi\u0006Dq!!\r\u0012\u0001\u0004\t\u0019$A\u0005tK:$XM\\2fgB!\u0011QGA\u001f\u001d\u0011\t9$!\u000f\u0011\u00059;\u0015bAA\u001e\u000f\u00061\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000fH\u0011\u001d\t)%\u0005a\u0001\u0003\u000f\na\u0001\\8dC2,\u0007\u0003BA%\u0003#j!!a\u0013\u000b\t\u0005%\u0012Q\n\u0006\u0003\u0003\u001f\nAA[1wC&!\u00111KA&\u0005\u0019aunY1mK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\bG\u0006e\u0013QLA1\u0011\u0019\tYF\u0005a\u00013\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u0002`I\u0001\r!W\u0001\n]\u0016<8+Z2p]\u0012Da!a\u0019\u0013\u0001\u0004I\u0016\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\bG\u0006%\u00141NA7\u0011\u001d96\u0003%AA\u0002eCq!X\n\u0011\u0002\u0003\u0007\u0011\fC\u0004`'A\u0005\t\u0019A-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u000f\u0016\u00043\u0006U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005u)\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u00065\u0013\u0001\u00027b]\u001eLA!a\u0010\u0002\u0014\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0014\t\u0004\r\u0006}\u0015bAAQ\u000f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QBAT\u0011%\tI+GA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0003b!!-\u00028\u00065QBAAZ\u0015\r\t)lR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA]\u0003g\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019a.a0\t\u0013\u0005%6$!AA\u0002\u00055\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a$\u0002F\"I\u0011\u0011\u0016\u000f\u0002\u0002\u0003\u0007\u0011QT\u0001\u0007KF,\u0018\r\\:\u0015\u00079\fY\rC\u0005\u0002*v\t\t\u00111\u0001\u0002\u000e!\u001a\u0002!a4\u0002V\u0006]\u00171\\Ao\u0003C\f\u0019/a:\u0002jB\u0019\u0011(!5\n\u0007\u0005M'FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0017\u0001T0G+:\u001bu\fK:uenc\u0003\u0005\\1oO2\u00023m\\;oiJLX,\u000b\u0011.AM\u0003H.\u001b;tA\u0001\u001cHO\u001d1!S:$x\u000eI1oA\u0005\u0014(/Y=!_\u001a\u0004\u0013M\u001d:bs\u0002zg\rI<pe\u0012\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty.\u00018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0015\u000e\t;iKJ,\u0017\u0005I$p_\u0012\u0004Sn\u001c:oS:<gfJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[&\u0005S5#Y\t\"\b.\u001a:fEuc3LI$p_\u0012\u0014CFI7pe:Lgn\u001a\u0012^;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002f\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u00111^\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\n'\u0016tG/\u001a8dKN\u0004\"!O\u0010\u0014\u000b}\t\u00190a@\u0011\u0011\u0005U\u00181`-Z3\u000el!!a>\u000b\u0007\u0005ex)A\u0004sk:$\u0018.\\3\n\t\u0005u\u0018q\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\t\t\u0015\u0011QJ\u0001\u0003S>L1!\u0016B\u0002)\t\ty/\u0001\u0005u_N#(/\u001b8h)\t\ty)A\u0003baBd\u0017\u0010F\u0004d\u0005'\u0011)Ba\u0006\t\u000b]\u0013\u0003\u0019A-\t\u000fu\u0013\u0003\u0013!a\u00013\"9qL\tI\u0001\u0002\u0004I\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\"\t5\u0002#\u0002$\u0003$\t\u001d\u0012b\u0001B\u0013\u000f\n1q\n\u001d;j_:\u0004bA\u0012B\u00153fK\u0016b\u0001B\u0016\u000f\n1A+\u001e9mKNB\u0001Ba\f&\u0003\u0003\u0005\raY\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005s\u0001B!!%\u0003<%!!QHAJ\u0005\u0019y%M[3di\u0002")
public class Sentences
extends TernaryExpression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences x$0) {
        return Sentences$.MODULE$.unapply(x$0);
    }

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.language();
    }

    @Override
    public Expression third() {
        return this.country();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object string = this.str().eval(input);
        if (string == null) {
            genericArrayData = null;
        } else {
            UTF8String languageStr = (UTF8String)this.language().eval(input);
            UTF8String countryStr = (UTF8String)this.country().eval(input);
            Locale locale = languageStr != null && countryStr != null ? new Locale(languageStr.toString(), countryStr.toString()) : Locale.US;
            genericArrayData = this.getSentences(((UTF8String)string).toString(), locale);
        }
        return genericArrayData;
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    @Override
    public Sentences withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.language();
                break;
            }
            case 2: {
                object = this.country();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "language";
                break;
            }
            case 2: {
                string = "country";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

