/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpCount$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Size;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Returns a count of the number of times that the regular expression pattern `regexp` is matched in the string `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Ste(v|ph)en');\n       2\n      > SELECT _FUNC_('abcdefghijklmnopqrstuvwxyz', '[a-z]{3}');\n       8\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u000f\u001e\u0001*B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005W!A!\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005L\u0001\tE\t\u0015!\u0003,\u0011\u0015a\u0005\u0001\"\u0001N\u0011!\t\u0006\u0001#b\u0001\n\u0003B\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00026\u0001\t#Z\u0007bB9\u0001\u0003\u0003%\tA\u001d\u0005\bk\u0002\t\n\u0011\"\u0001w\u0011!\t\u0019\u0001AI\u0001\n\u00031\b\"CA\u0003\u0001\u0005\u0005I\u0011IA\u0004\u0011%\t9\u0002AA\u0001\n\u0003\tI\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\t\u0013\u0005E\u0003!!A\u0005B\u0005Ms!CA?;\u0005\u0005\t\u0012AA@\r!aR$!A\t\u0002\u0005\u0005\u0005B\u0002'\u0017\t\u0003\tI\nC\u0005\u0002\u001cZ\t\t\u0011\"\u0012\u0002\u001e\"I\u0011q\u0014\f\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003O3\u0012\u0011!CA\u0003SC\u0011\"a/\u0017\u0003\u0003%I!!0\u0003\u0017I+w-\u0012=q\u0007>,h\u000e\u001e\u0006\u0003=}\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M1\u0001aK\u00183km\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002-a%\u0011\u0011'\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u0002-g%\u0011A'\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t9\u0001K]8ek\u000e$\bC\u0001\u001fE\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002AS\u00051AH]8pizJ\u0011\u0001O\u0005\u0003\u0007^\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\na1+\u001a:jC2L'0\u00192mK*\u00111iN\u0001\u0005Y\u00164G/F\u0001,\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2AT(Q!\ta\u0003\u0001C\u0003H\u000b\u0001\u00071\u0006C\u0003K\u000b\u0001\u00071&A\u0006sKBd\u0017mY3nK:$\u0018A\u00039sKR$\u0018PT1nKV\tA\u000b\u0005\u0002V3:\u0011ak\u0016\t\u0003}]J!\u0001W\u001c\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031^\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002=B\u0019AhX\u0016\n\u0005\u00014%aA*fc\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\r\u00042\u0001P0e!\t)\u0007.D\u0001g\u0015\t9\u0017%A\u0003usB,7/\u0003\u0002jM\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\"A\u00147\t\u000b5T\u0001\u0019\u00018\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0004y=\\\u0013B\u00019G\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0002OgRDqaR\u0006\u0011\u0002\u0003\u00071\u0006C\u0004K\u0017A\u0005\t\u0019A\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqO\u000b\u0002,q.\n\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003}^\n!\"\u00198o_R\fG/[8o\u0013\r\t\ta\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0014\u0005!!.\u0019<b\u0013\rQ\u0016QB\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\u00012ANA\u000f\u0013\r\tyb\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003K\tY\u0003E\u00027\u0003OI1!!\u000b8\u0005\r\te.\u001f\u0005\n\u0003[\u0001\u0012\u0011!a\u0001\u00037\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001a!\u0019\t)$a\u000f\u0002&5\u0011\u0011q\u0007\u0006\u0004\u0003s9\u0014AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0013\u0011\n\t\u0004m\u0005\u0015\u0013bAA$o\t9!i\\8mK\u0006t\u0007\"CA\u0017%\u0005\u0005\t\u0019AA\u0013\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u0011q\n\u0005\n\u0003[\u0019\u0012\u0011!a\u0001\u00037\ta!Z9vC2\u001cH\u0003BA\"\u0003+B\u0011\"!\f\u0015\u0003\u0003\u0005\r!!\n)/\u0001\tI&a\u0018\u0002b\u0005\u0015\u0014qMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0004c\u0001\u0017\u0002\\%\u0019\u0011QL\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111M\u0001\u0002$)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u0004\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043m\\;oi\u0002zg\r\t;iK\u0002rW/\u001c2fe\u0002zg\r\t;j[\u0016\u001c\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007\u0005]1ui\u0016\u0014h\u000e\t1sK\u001e,\u0007\u0010\u001d1!SN\u0004S.\u0019;dQ\u0016$\u0007%\u001b8!i\",\u0007e\u001d;sS:<\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA5\u0003\u0005\u0015$\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004#/\u001a9sKN,g\u000e^5oO\u0002\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0015\u00064\u0018\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001c\u0002\u0003\u0007S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*uKZ,g\u000e\t&p]\u0016\u001c\b%\u00198eAM#X\r\u001d5f]\u0002\u001aV.\u001b;iA\u0005\u0014X\r\t;iK\u0002\u0012Wm\u001d;!a2\f\u00170\u001a:tO1\u0002se\u0015;fQYd\b\u000f[\u0015f]\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'm\u00193fM\u001eD\u0017N[6m[:|\u0007/\u001d:tiV4x\u000f_={O1\u0002seW1.uv[8'`\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0014!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAA>\u00031\u0019HO]5oO~3WO\\2t\u0003-\u0011VmZ#ya\u000e{WO\u001c;\u0011\u0005122#\u0002\f\u0002\u0004\u0006=\u0005cBAC\u0003\u0017[3FT\u0007\u0003\u0003\u000fS1!!#8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!$\u0002\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002\u0012\u0005\u0011\u0011n\\\u0005\u0004\u000b\u0006MECAA@\u0003!!xn\u0015;sS:<GCAA\u0005\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q\u00151UAS\u0011\u00159\u0015\u00041\u0001,\u0011\u0015Q\u0015\u00041\u0001,\u0003\u001d)h.\u00199qYf$B!a+\u00028B)a'!,\u00022&\u0019\u0011qV\u001c\u0003\r=\u0003H/[8o!\u00151\u00141W\u0016,\u0013\r\t)l\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005e&$!AA\u00029\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\f\u0005\u0003\u0002\f\u0005\u0005\u0017\u0002BAb\u0003\u001b\u0011aa\u00142kK\u000e$\b")
public class RegExpCount
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegExpCount x$0) {
        return RegExpCount$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, RegExpCount> tupled() {
        return RegExpCount$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegExpCount>> curried() {
        return RegExpCount$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        RegExpCount regExpCount = this;
        synchronized (regExpCount) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        RegExpCount regExpCount = this;
        synchronized (regExpCount) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new Size(new RegExpExtractAll(this.left(), this.right(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0))), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "regexp_count";
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.left(), this.right()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public RegExpCount withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public RegExpCount copy(Expression left, Expression right) {
        return new RegExpCount(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegExpCount";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpCount;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpCount regExpCount = (RegExpCount)x$1;
        Expression expression = this.left();
        Expression expression2 = regExpCount.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regExpCount.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regExpCount.canEqual(this)) return false;
        return true;
    }

    public RegExpCount(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

