/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class ModelSelectionViaTrainValidationSplitExample$ {
    public static final ModelSelectionViaTrainValidationSplitExample$ MODULE$ = new ModelSelectionViaTrainValidationSplitExample$();

    public void main(String[] args) {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("ModelSelectionViaTrainValidationSplitExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        Dataset[] datasetArray = data.randomSplit(new double[]{0.9, 0.1}, 12345L);
        if (datasetArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)datasetArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset training = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Dataset test = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        Tuple2 tuple22 = tuple2;
        Dataset training2 = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        LinearRegression lr = new LinearRegression().setMaxIter(10);
        ParamMap[] paramGrid = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.01}).addGrid(lr.fitIntercept()).addGrid(lr.elasticNetParam(), new double[]{0.0, 0.5, 1.0}).build();
        TrainValidationSplit trainValidationSplit = new TrainValidationSplit().setEstimator((Estimator)lr).setEvaluator((Evaluator)new RegressionEvaluator()).setEstimatorParamMaps(paramGrid).setTrainRatio(0.8).setParallelism(2);
        TrainValidationSplitModel model = trainValidationSplit.fit(training2);
        model.transform(test2).select("features", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label", "prediction"})).show();
        spark.stop();
    }

    private ModelSelectionViaTrainValidationSplitExample$() {
    }
}

