/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.internal.server.annotation.AggregatedResponseConverterFunction;
import com.linecorp.armeria.internal.server.annotation.CompositeResponseConverterFunction;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.annotation.ByteArrayResponseConverterFunction;
import com.linecorp.armeria.server.annotation.DelegatingResponseConverterFunctionProvider;
import com.linecorp.armeria.server.annotation.HttpFileResponseConverterFunction;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunctionProvider;
import com.linecorp.armeria.server.annotation.StringResponseConverterFunction;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResponseConverterFunctionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResponseConverterFunctionUtil.class);
    private static final List<ResponseConverterFunction> defaultResponseConverters = ImmutableList.of(new JacksonResponseConverterFunction(), new StringResponseConverterFunction(), new ByteArrayResponseConverterFunction(), new HttpFileResponseConverterFunction());
    private static final List<ResponseConverterFunctionProvider> responseConverterProviders = ImmutableList.copyOf(ServiceLoader.load(ResponseConverterFunctionProvider.class, ResponseConverterFunctionUtil.class.getClassLoader()));
    private static final List<DelegatingResponseConverterFunctionProvider> delegatingResponseConverterProviders = ImmutableList.copyOf(ServiceLoader.load(DelegatingResponseConverterFunctionProvider.class, ResponseConverterFunctionUtil.class.getClassLoader()));

    static ResponseConverterFunction newResponseConverter(Type returnType, List<ResponseConverterFunction> responseConverters) {
        List nonDelegatingSpiConverters = responseConverterProviders.stream().map(provider -> provider.createResponseConverterFunction(returnType)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        ImmutableCollection backingConverters = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(responseConverters)).addAll((Iterable)nonDelegatingSpiConverters)).addAll(defaultResponseConverters)).build();
        CompositeResponseConverterFunction responseConverter = new CompositeResponseConverterFunction((ImmutableList<ResponseConverterFunction>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)backingConverters)).add(new AggregatedResponseConverterFunction(new CompositeResponseConverterFunction((ImmutableList<ResponseConverterFunction>)backingConverters)))).build());
        for (DelegatingResponseConverterFunctionProvider provider2 : delegatingResponseConverterProviders) {
            ResponseConverterFunction func = provider2.createResponseConverterFunction(returnType, responseConverter);
            if (func == null) continue;
            return func;
        }
        return responseConverter;
    }

    private ResponseConverterFunctionUtil() {
    }

    static {
        if (!responseConverterProviders.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)ResponseConverterFunctionProvider.class.getSimpleName(), (Object)responseConverterProviders);
        }
        if (!delegatingResponseConverterProviders.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)DelegatingResponseConverterFunctionProvider.class.getSimpleName(), (Object)delegatingResponseConverterProviders);
        }
    }
}

