/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.sql.SQLTransientException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.internal.EPSGFactoryProxy;
import org.apache.sis.referencing.internal.shared.FilteredIterator;
import org.apache.sis.referencing.internal.shared.LazySet;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class AuthorityFactories<T extends AuthorityFactory>
extends LazySet<T> {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    private static GeodeticAuthorityFactory EPSG;
    static final MultiAuthoritiesFactory ALL;
    private final Class<T> service;

    private AuthorityFactories(Class<T> type) {
        this.service = type;
    }

    @Override
    protected Iterator<? extends T> createSourceIterator() {
        ServiceLoader<T> loader;
        try {
            loader = ServiceLoader.load(this.service, Reflect.getContextClassLoader());
        }
        catch (SecurityException e) {
            Reflect.log(AuthorityFactories.class, (String)"createSourceIterator", (SecurityException)e);
            loader = ServiceLoader.load(this.service);
        }
        return new FilteredIterator<AuthorityFactory, AuthorityFactory>(loader.iterator(), element -> element instanceof EPSGFactoryProxy ? null : element);
    }

    @Override
    protected T[] initialValues() {
        return new GeodeticAuthorityFactory[]{AuthorityFactories.getEPSG(true)};
    }

    static synchronized void setEPSG(GeodeticAuthorityFactory factory) {
        EPSG = factory;
    }

    static synchronized GeodeticAuthorityFactory getEPSG(boolean test) {
        if (EPSG == null) {
            try {
                EPSG = new EPSGFactory(null);
                if (test) {
                    EPSG.createPrimeMeridian("8901");
                }
            }
            catch (FactoryException e) {
                AuthorityFactories.log((Exception)((Object)e), false);
                EPSG = EPSGFactoryFallback.INSTANCE;
            }
        }
        return EPSG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static GeodeticAuthorityFactory fallback(UnavailableFactoryException e) throws UnavailableFactoryException {
        AuthorityFactory unavailable = e.getUnavailableFactory();
        if (unavailable instanceof EPSGFactoryFallback) {
            throw e;
        }
        boolean isWarning = true;
        if (!(e.getCause() instanceof SQLTransientException)) {
            Class<AuthorityFactories> clazz = AuthorityFactories.class;
            // MONITORENTER : org.apache.sis.referencing.AuthorityFactories.class
            if (unavailable == EPSG) {
                ALL.reload();
                EPSG = EPSGFactoryFallback.INSTANCE;
                isWarning = false;
            }
            // MONITOREXIT : clazz
        }
        AuthorityFactories.log((Exception)((Object)e), isWarning);
        return EPSGFactoryFallback.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isUnavailable(UnavailableFactoryException e) {
        AuthorityFactory unavailable = e.getUnavailableFactory();
        if (unavailable instanceof EPSGFactoryFallback) {
            return true;
        }
        if (e.getCause() instanceof SQLTransientException) {
            return true;
        }
        Class<AuthorityFactories> clazz = AuthorityFactories.class;
        synchronized (AuthorityFactories.class) {
            if (unavailable == EPSG) {
                ALL.reload();
                EPSG = EPSGFactoryFallback.INSTANCE;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private static void log(Exception e, boolean isWarning) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        LogRecord record = new LogRecord(isWarning ? Level.WARNING : Level.CONFIG, message);
        if (isWarning && !(e instanceof UnavailableFactoryException)) {
            record.setThrown(e);
        }
        Logging.completeAndLog((Logger)LOGGER, CRS.class, (String)"getAuthorityFactory", (LogRecord)record);
    }

    static IdentifiedObjectFinder finderForEPSG() throws FactoryException {
        GeodeticAuthorityFactory factory = AuthorityFactories.getEPSG(false);
        if (factory instanceof EPSGFactoryFallback) {
            return ((EPSGFactoryFallback)factory).newIdentifiedObjectFinder();
        }
        return new IdentifiedObjectFinder.Wrapper(factory.newIdentifiedObjectFinder()){
            private boolean isUsingFallback;

            private void report(UnavailableFactoryException e) throws FactoryException {
                if (this.isUsingFallback) {
                    throw e;
                }
                this.isUsingFallback = true;
                this.delegate(AuthorityFactories.fallback(e).newIdentifiedObjectFinder());
            }

            @Override
            public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
                while (true) {
                    try {
                        return super.find(object);
                    }
                    catch (UnavailableFactoryException e) {
                        this.report(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public IdentifiedObject findSingleton(IdentifiedObject object) throws FactoryException {
                while (true) {
                    try {
                        return super.findSingleton(object);
                    }
                    catch (UnavailableFactoryException e) {
                        this.report(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            protected Iterable<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
                while (true) {
                    try {
                        return super.getCodeCandidates(object);
                    }
                    catch (UnavailableFactoryException e) {
                        this.report(e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    static {
        ALL = new MultiAuthoritiesFactory((Iterable)((Object)new AuthorityFactories<CRSAuthorityFactory>(CRSAuthorityFactory.class)), (Iterable)((Object)new AuthorityFactories<CSAuthorityFactory>(CSAuthorityFactory.class)), (Iterable)((Object)new AuthorityFactories<DatumAuthorityFactory>(DatumAuthorityFactory.class)), (Iterable)((Object)new AuthorityFactories<CoordinateOperationAuthorityFactory>(CoordinateOperationAuthorityFactory.class))){
            {
                this.setLenient(true);
            }

            @Override
            public void reload() {
                AuthorityFactories.setEPSG(null);
                super.reload();
            }
        };
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

            protected void classpathChanged() {
                ALL.reload();
            }
        });
    }
}

