/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.shiro.web.jaxrs;


import org.apache.shiro.authz.UnauthenticatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;

/**
 * JAX-RS exception mapper used to map Shiro {@link UnauthenticatedException} to HTTP status codes.
 * {@link UnauthenticatedException} will be mapped to 403.
 *
 * @since 1.4
 */
public class UnauthenticatedExceptionExceptionMapper implements ExceptionMapper<UnauthenticatedException> {

    private static final Logger LOG = LoggerFactory.getLogger(UnauthenticatedExceptionExceptionMapper.class);

    @Override
    public Response toResponse(UnauthenticatedException exception) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("unauthenticated.", exception);
        }

        return Response.status(Status.FORBIDDEN).build();
    }
}
