/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.loadbalance;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.cluster.ServantInvokerAliveStat;
import com.qq.tars.client.rpc.InvokerComparator;
import com.qq.tars.client.rpc.loadbalance.LoadBalanceHelper;
import com.qq.tars.common.util.CollectionUtils;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.exc.NoInvokerException;
import com.qq.tars.support.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;

public class ConsistentHashLoadBalance<T>
implements LoadBalance<T> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final ServantProxyConfig config;
    private final InvokerComparator comparator = new InvokerComparator();
    private volatile TreeMap<Long, Invoker<T>> conHashInvokersCache = null;
    private volatile List<Invoker<T>> sortedInvokersCache = null;

    public ConsistentHashLoadBalance(ServantProxyConfig config) {
        this.config = config;
    }

    @Override
    public Invoker<T> select(InvokeContext invocation) throws NoInvokerException {
        List<Invoker<T>> sortedInvokers;
        long consistentHash = Math.abs(StringUtils.convertLong(invocation.getAttachment("taf_consistent_hash"), 0L));
        consistentHash &= 0xFFFFFFFFL;
        TreeMap<Long, Invoker<T>> conHashInvokers = this.conHashInvokersCache;
        if (conHashInvokers != null && !conHashInvokers.isEmpty()) {
            Invoker<T> invoker;
            if (!conHashInvokers.containsKey(consistentHash)) {
                SortedMap<Long, Invoker<T>> tailMap = conHashInvokers.tailMap(consistentHash);
                consistentHash = tailMap.isEmpty() ? conHashInvokers.firstKey().longValue() : tailMap.firstKey().longValue();
            }
            if ((invoker = conHashInvokers.get(consistentHash)).isAvailable()) {
                return invoker;
            }
            ServantInvokerAliveStat stat = ServantInvokerAliveChecker.get(invoker.getUrl());
            if (stat.isAlive() || stat.getLastRetryTime() + (long)(this.config.getTryTimeInterval() * 1000) < System.currentTimeMillis()) {
                logger.info("try to use inactive invoker|" + invoker.getUrl().toIdentityString());
                stat.setLastRetryTime(System.currentTimeMillis());
                return invoker;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.config.getSimpleObjectName() + " can't find active invoker using consistent hash loadbalance. try to use normal hash");
        }
        if ((sortedInvokers = this.sortedInvokersCache) == null || sortedInvokers.isEmpty()) {
            throw new NoInvokerException("no such active connection invoker");
        }
        ArrayList<Invoker<T>> list = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : sortedInvokers) {
            if (!invoker.isAvailable()) {
                ServantInvokerAliveStat stat = ServantInvokerAliveChecker.get(invoker.getUrl());
                if (!stat.isAlive() && stat.getLastRetryTime() + (long)(this.config.getTryTimeInterval() * 1000) >= System.currentTimeMillis()) continue;
                list.add(invoker);
                continue;
            }
            list.add(invoker);
        }
        if (list.isEmpty()) {
            throw new NoInvokerException(this.config.getSimpleObjectName() + " try to select active invoker, size=" + sortedInvokers.size() + ", no such active connection invoker");
        }
        Invoker invoker = (Invoker)list.get((int)(consistentHash % (long)list.size()));
        if (!invoker.isAvailable()) {
            logger.info("try to use inactive invoker|" + invoker.getUrl().toIdentityString());
            ServantInvokerAliveChecker.get(invoker.getUrl()).setLastRetryTime(System.currentTimeMillis());
        }
        return invoker;
    }

    @Override
    public void refresh(Collection<Invoker<T>> invokers) {
        logger.info(this.config.getSimpleObjectName() + " try to refresh ConsistentHashLoadBalance's invoker cache, size=" + (invokers == null || invokers.isEmpty() ? 0 : invokers.size()));
        if (CollectionUtils.isEmpty(invokers)) {
            this.sortedInvokersCache = null;
            this.conHashInvokersCache = null;
            return;
        }
        ArrayList<Invoker<T>> sortedInvokersTmp = new ArrayList<Invoker<T>>(invokers);
        sortedInvokersTmp.sort(this.comparator);
        this.sortedInvokersCache = sortedInvokersTmp;
        this.conHashInvokersCache = LoadBalanceHelper.buildConsistentHashCircle(sortedInvokersTmp, this.config);
        logger.info(this.config.getSimpleObjectName() + " refresh ConsistentHashLoadBalance's invoker cache done, conHashInvokersCache size=" + (this.conHashInvokersCache == null || this.conHashInvokersCache.isEmpty() ? 0 : this.conHashInvokersCache.size()) + ", sortedInvokersCache size=" + (this.sortedInvokersCache == null || this.sortedInvokersCache.isEmpty() ? 0 : this.sortedInvokersCache.size()));
    }
}

