/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.polaris;

import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.polaris.PolarisSyncDataService;
import org.apache.shenyu.sync.data.polaris.config.PolarisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={PolarisSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.polaris", name={"url"})
public class PolarisSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisSyncDataConfiguration.class);

    @Bean
    public SyncDataService polarisSyncDataService(ObjectProvider<PolarisConfig> polarisConfig, ObjectProvider<ConfigFileService> configFileServices, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers, ObjectProvider<ShenyuConfig> shenyuConfig) {
        LOGGER.info("you use polaris sync shenyu data.......");
        return new PolarisSyncDataService((PolarisConfig)polarisConfig.getIfAvailable(), (ConfigFileService)configFileServices.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorSubscribers.getIfAvailable(), (List)discoveryUpstreamDataSubscribers.getIfAvailable(), (ShenyuConfig)shenyuConfig.getIfAvailable());
    }

    @Bean
    public ConfigFileService polarisConfigServices(PolarisConfig polarisConfig) {
        com.tencent.polaris.api.config.Configuration configuration = ConfigAPIFactory.defaultConfig();
        configuration.getConfigFile().getServerConnector().setAddresses(Collections.singletonList(polarisConfig.getUrl()));
        return ConfigFileServiceFactory.createConfigFileService((com.tencent.polaris.api.config.Configuration)configuration);
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.polaris")
    public PolarisConfig polarisConfig() {
        return new PolarisConfig();
    }
}

