/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.dubbo.common.handler;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;

public abstract class AbstractDubboMetaDataHandler
implements MetaDataHandler {
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void handle(MetaData metaData) {
        MetaData exist = (MetaData)META_DATA.get(metaData.getPath());
        if (Objects.isNull(exist) || !this.isInitialized(metaData)) {
            this.initReference(metaData);
        } else if (!(Objects.equals(metaData.getServiceName(), exist.getServiceName()) && Objects.equals(metaData.getRpcExt(), exist.getRpcExt()) && Objects.equals(metaData.getParameterTypes(), exist.getParameterTypes()) && Objects.equals(metaData.getMethodName(), exist.getMethodName()))) {
            this.updateReference(metaData);
        }
        META_DATA.put(metaData.getPath(), metaData);
    }

    protected abstract boolean isInitialized(MetaData var1);

    protected abstract void initReference(MetaData var1);

    protected abstract void updateReference(MetaData var1);

    public void remove(MetaData metaData) {
        this.invalidateReference(metaData);
        META_DATA.remove(metaData.getPath());
    }

    protected abstract void invalidateReference(MetaData var1);

    public String rpcType() {
        return RpcTypeEnum.DUBBO.getName();
    }
}

