/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.enums.RunningModeEnum;
import org.apache.shenyu.common.timer.AbstractRoundTask;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.apache.shenyu.common.timer.WheelTimerFactory;
import org.apache.shenyu.plugin.sync.data.websocket.client.ShenyuWebsocketClient;
import org.apache.shenyu.plugin.sync.data.websocket.config.WebsocketConfig;
import org.apache.shenyu.sync.data.api.AiProxyApiKeyDataSubscriber;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class WebsocketSyncDataService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketSyncDataService.class);
    private static final String ORIGIN_HEADER_NAME = "Origin";
    private final WebsocketConfig websocketConfig;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;
    private final List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers;
    private final List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers;
    private final List<AiProxyApiKeyDataSubscriber> aiProxyApiKeyDataSubscribers;
    private final List<ShenyuWebsocketClient> clients = Lists.newArrayList();
    private final String namespaceId;
    private final Timer timer = WheelTimerFactory.getSharedTimer();
    private TimerTask timerTask;
    private final ServerProperties serverProperties;

    public WebsocketSyncDataService(WebsocketConfig websocketConfig, ShenyuConfig shenyuConfig, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers, List<AiProxyApiKeyDataSubscriber> aiProxyApiKeyDataSubscribers, ServerProperties serverProperties) {
        this.websocketConfig = websocketConfig;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.proxySelectorDataSubscribers = proxySelectorDataSubscribers;
        this.discoveryUpstreamDataSubscribers = discoveryUpstreamDataSubscribers;
        this.aiProxyApiKeyDataSubscribers = aiProxyApiKeyDataSubscribers;
        this.namespaceId = shenyuConfig.getNamespace();
        this.serverProperties = serverProperties;
        LOG.info("start init connecting...");
        List<String> urls = websocketConfig.getUrls();
        for (String url : urls) {
            if (StringUtils.isNotEmpty((CharSequence)websocketConfig.getAllowOrigin())) {
                ImmutableMap headers = ImmutableMap.of((Object)ORIGIN_HEADER_NAME, (Object)websocketConfig.getAllowOrigin());
                this.clients.add(new ShenyuWebsocketClient(URI.create(url), (Map<String, String>)headers, Objects.requireNonNull(pluginDataSubscriber), metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers, this.aiProxyApiKeyDataSubscribers, this.namespaceId, serverProperties.getPort()));
                continue;
            }
            this.clients.add(new ShenyuWebsocketClient(URI.create(url), Objects.requireNonNull(pluginDataSubscriber), metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers, this.aiProxyApiKeyDataSubscribers, this.namespaceId, serverProperties.getPort()));
        }
        LOG.info("start check task...");
        this.timerTask = new AbstractRoundTask(null, TimeUnit.SECONDS.toMillis(60L)){

            public void doRun(String key, TimerTask timerTask) {
                WebsocketSyncDataService.this.masterCheck();
            }
        };
        this.timer.add(this.timerTask);
    }

    private void masterCheck() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("master checking task start...");
        }
        if (CollectionUtils.isEmpty(this.clients)) {
            List<String> urls = this.websocketConfig.getUrls();
            for (String url : urls) {
                if (StringUtils.isNotEmpty((CharSequence)this.websocketConfig.getAllowOrigin())) {
                    ImmutableMap headers = ImmutableMap.of((Object)ORIGIN_HEADER_NAME, (Object)this.websocketConfig.getAllowOrigin());
                    this.clients.add(new ShenyuWebsocketClient(URI.create(url), (Map<String, String>)headers, Objects.requireNonNull(this.pluginDataSubscriber), this.metaDataSubscribers, this.authDataSubscribers, this.proxySelectorDataSubscribers, this.discoveryUpstreamDataSubscribers, this.aiProxyApiKeyDataSubscribers, this.namespaceId, this.serverProperties.getPort()));
                    continue;
                }
                this.clients.add(new ShenyuWebsocketClient(URI.create(url), Objects.requireNonNull(this.pluginDataSubscriber), this.metaDataSubscribers, this.authDataSubscribers, this.proxySelectorDataSubscribers, this.discoveryUpstreamDataSubscribers, this.aiProxyApiKeyDataSubscribers, this.namespaceId, this.serverProperties.getPort()));
            }
        }
        Iterator<ShenyuWebsocketClient> iterator = this.clients.iterator();
        while (iterator.hasNext()) {
            ShenyuWebsocketClient websocketClient = iterator.next();
            if (!websocketClient.isOpen()) {
                iterator.remove();
                continue;
            }
            String runningMode = websocketClient.getRunningMode();
            if (Objects.equals(runningMode, RunningModeEnum.STANDALONE.name())) {
                LOG.info("admin running in standalone mode...");
                this.timerTask.cancel();
                return;
            }
            if (websocketClient.isConnectedToMaster()) continue;
            websocketClient.nowClose();
            iterator.remove();
        }
    }

    public void close() {
        if (CollectionUtils.isNotEmpty(this.clients)) {
            for (ShenyuWebsocketClient client : this.clients) {
                if (!Objects.nonNull((Object)client)) continue;
                client.close();
            }
        }
        if (Objects.nonNull(this.timerTask)) {
            this.timerTask.cancel();
        }
        this.timer.shutdown();
    }

    public WebsocketConfig getWebsocketConfig() {
        return this.websocketConfig;
    }

    public PluginDataSubscriber getPluginDataSubscriber() {
        return this.pluginDataSubscriber;
    }

    public List<MetaDataSubscriber> getMetaDataSubscribers() {
        return this.metaDataSubscribers;
    }

    public List<AuthDataSubscriber> getAuthDataSubscribers() {
        return this.authDataSubscribers;
    }

    public List<ProxySelectorDataSubscriber> getProxySelectorDataSubscribers() {
        return this.proxySelectorDataSubscribers;
    }

    public List<DiscoveryUpstreamDataSubscriber> getDiscoveryUpstreamDataSubscribers() {
        return this.discoveryUpstreamDataSubscribers;
    }
}

