/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseOutputStream;
import java.io.IOException;

public abstract class AbstractByteArrayOutputStream
extends ClickHouseOutputStream {
    protected final byte[] buffer;
    protected int position;

    protected void flushBuffer() throws IOException {
        this.flushBuffer(this.buffer, 0, this.position);
        this.position = 0;
    }

    protected abstract void flushBuffer(byte[] var1, int var2, int var3) throws IOException;

    protected AbstractByteArrayOutputStream(ClickHouseFile file, int bufferSize, Runnable postCloseAction) {
        super(file, postCloseAction);
        this.buffer = new byte[bufferSize];
        this.position = 0;
    }

    @Override
    public ClickHouseOutputStream transferBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.flushBuffer(bytes, offset, length);
        this.position = 0;
        return this;
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer[this.position++] = b;
        if (this.position >= this.buffer.length) {
            this.flushBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        int limit = this.buffer.length;
        while (length > 0) {
            int remain = limit - this.position;
            if (length < remain) {
                System.arraycopy(bytes, offset, this.buffer, this.position, length);
                this.position += length;
                length = 0;
                continue;
            }
            System.arraycopy(bytes, offset, this.buffer, this.position, remain);
            this.position = limit;
            offset += remain;
            length -= remain;
            this.flushBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int written = 0;
        while ((written = writer.update(this.buffer, this.position, this.buffer.length)) < 0) {
            this.flushBuffer();
        }
        this.position += written;
        return this;
    }
}

