/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.internal;

import com.alipay.hessian.NameBlackListFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class InternalNameBlackListFilter
extends NameBlackListFilter {
    private static final String EXTERNAL_BLACK_LIST = "external/serialize.blacklist";
    private static final String USER_BLACK_LIST = System.getProperty("serialize.blacklist.file");
    private static final String DEFAULT_BLACK_LIST = "security/serialize.blacklist";
    static final List<String> INTERNAL_BLACK_LIST = InternalNameBlackListFilter.readBlackList();
    private static volatile InternalNameBlackListFilter instance;

    public InternalNameBlackListFilter() {
        super(INTERNAL_BLACK_LIST);
    }

    public InternalNameBlackListFilter(int maxCacheSize) {
        super(INTERNAL_BLACK_LIST, maxCacheSize);
    }

    static List<String> readBlackList() {
        List<Object> result = new ArrayList();
        result = InternalNameBlackListFilter.readBlackList(EXTERNAL_BLACK_LIST);
        if (result.size() != 0) {
            return result;
        }
        result = InternalNameBlackListFilter.readBlackList(USER_BLACK_LIST);
        if (result.size() != 0) {
            return result;
        }
        result = InternalNameBlackListFilter.readBlackList(DEFAULT_BLACK_LIST);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> readBlackList(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        if (fileName == null || fileName.equals("")) {
            return result;
        }
        ClassLoader classLoader = DEFAULT_BLACK_LIST.equals(fileName) ? InternalNameBlackListFilter.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream != null) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(inputStream);
                while (scanner.hasNextLine()) {
                    String nextLine = scanner.nextLine();
                    if (InternalNameBlackListFilter.isBlank(nextLine)) continue;
                    result.add(nextLine);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return result;
    }

    static boolean isBlank(String cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InternalNameBlackListFilter Singleton() {
        if (instance != null) return instance;
        Class<InternalNameBlackListFilter> clazz = InternalNameBlackListFilter.class;
        synchronized (InternalNameBlackListFilter.class) {
            if (instance != null) return instance;
            instance = new InternalNameBlackListFilter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

