/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.SessionManager;
import com.qq.tars.net.core.nio.Acceptor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.TCPSession;
import com.qq.tars.net.util.Utils;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPAcceptor
extends Acceptor {
    public TCPAcceptor(SelectorManager selectorManager) {
        super(selectorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectEvent(SelectionKey key) throws IOException {
        SocketChannel client = (SocketChannel)key.channel();
        TCPSession session = (TCPSession)key.attachment();
        if (session == null) {
            throw new RuntimeException("The session is null when connecting to ...");
        }
        try {
            client.finishConnect();
            key.interestOps(1);
            session.setStatus(Session.SessionStatus.CLIENT_CONNECTED);
        }
        finally {
            session.finishConnect();
        }
    }

    @Override
    public void handleAcceptEvent(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        channel.socket().setTcpNoDelay(this.selectorManager.isTcpNoDelay());
        channel.configureBlocking(false);
        Utils.setQosFlag(channel.socket());
        TCPSession session = new TCPSession(this.selectorManager);
        session.setChannel(channel);
        session.setStatus(Session.SessionStatus.SERVER_CONNECTED);
        session.setKeepAlive(this.selectorManager.isKeepAlive());
        session.setTcpNoDelay(this.selectorManager.isTcpNoDelay());
        SessionManager.getSessionManager().registerSession(session);
        this.selectorManager.nextReactor().registerChannel(channel, 1, session);
    }

    @Override
    public void handleReadEvent(SelectionKey key) throws IOException {
        TCPSession session = (TCPSession)key.attachment();
        if (session == null) {
            throw new RuntimeException("The session is null when reading data...");
        }
        session.read();
    }

    @Override
    public void handleWriteEvent(SelectionKey key) throws IOException {
        TCPSession session = (TCPSession)key.attachment();
        if (session == null) {
            throw new RuntimeException("The session is null when writing data...");
        }
        session.doWrite();
    }
}

